/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.TimeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.web.admin.monitor.HttpServiceStatsProviderBootstrap;
import org.glassfish.web.admin.monitor.ServletStatsProvider;
import org.glassfish.web.admin.monitor.TimeStatData;

@AMXMetadata(type="servlet-instance-mon", group="monitoring")
@ManagedObject
@Description(value="Web Container Servlet Instance Statistics")
public class ServletInstanceStatsProvider {
    private static final Logger logger = HttpServiceStatsProviderBootstrap.logger;
    private static final String ERROR_COUNT_DESCRIPTION = "Number of error responses (that is, responses with a status code greater than or equal to 400)";
    private static final String MAX_TIME_DESCRIPTION = "Maximum response time";
    private static final String SERVICE_TIME_DESCRIPTION = "Aggregate response time";
    private static final String PROCESSING_TIME_DESCRIPTION = "Average response time";
    private static final String REQUEST_COUNT_DESCRIPTION = "Number of requests processed";
    private CountStatisticImpl errorCount = new CountStatisticImpl("ErrorCount", "count", "Number of error responses (that is, responses with a status code greater than or equal to 400)");
    private CountStatisticImpl requestCount = new CountStatisticImpl("RequestCount", "count", "Number of requests processed");
    private CountStatisticImpl maxTime = new CountStatisticImpl("MaxTime", "millisecond", "Maximum response time");
    private CountStatisticImpl processingTime = new CountStatisticImpl("ProcessingTime", "millisecond", "Average response time");
    private TimeStatisticImpl requestProcessTime = new TimeStatisticImpl(0L, 0L, 0L, 0L, "", "", "", System.currentTimeMillis(), -1L);
    private CountStatisticImpl serviceTime = new CountStatisticImpl("ServiceTime", "millisecond", "Aggregate response time");
    private String servletName;
    private String moduleName;
    private String vsName;
    private ServletStatsProvider servletStatsProvider;
    private ThreadLocal<TimeStatData> timeStatDataLocal = new ThreadLocal<TimeStatData>(){
        TimeStatData tsd;

        @Override
        protected TimeStatData initialValue() {
            this.tsd = new TimeStatData();
            return this.tsd;
        }

        @Override
        public TimeStatData get() {
            if (this.tsd == null) {
                this.tsd = new TimeStatData();
            }
            return this.tsd;
        }
    };

    public ServletInstanceStatsProvider(String servletName, String moduleName, String vsName, ServletStatsProvider servletStatsProvider) {
        this.servletName = servletName;
        this.moduleName = moduleName;
        this.vsName = vsName;
        this.servletStatsProvider = servletStatsProvider;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.vsName;
    }

    @ManagedAttribute(id="errorcount")
    @Description(value="Number of error responses (that is, responses with a status code greater than or equal to 400)")
    public CountStatistic getErrorCount() {
        return this.errorCount.getStatistic();
    }

    @ManagedAttribute(id="maxtime")
    @Description(value="Maximum response time")
    public CountStatistic getMaximumTime() {
        this.maxTime.setCount(this.requestProcessTime.getMaxTime());
        return this.maxTime;
    }

    @ManagedAttribute(id="servicetime")
    @Description(value="Aggregate response time")
    public CountStatistic getServiceTime() {
        this.serviceTime.setCount(this.requestProcessTime.getTotalTime());
        return this.serviceTime;
    }

    @ManagedAttribute(id="processingtime")
    @Description(value="Average response time")
    public CountStatistic getProcessingTime() {
        long count = this.requestProcessTime.getCount();
        long processTime = 0L;
        if (count != 0L) {
            processTime = this.requestProcessTime.getTotalTime() / count;
        }
        this.processingTime.setCount(processTime);
        return this.processingTime;
    }

    @ManagedAttribute(id="requestcount")
    @Description(value="Number of requests processed")
    public CountStatistic getCount() {
        this.requestCount.setCount(this.requestProcessTime.getCount());
        return this.requestCount;
    }

    @ProbeListener(value="glassfish:web:servlet:beforeServiceEvent")
    public void beforeServiceEvent(@ProbeParam(value="servletName") String servletName, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (this.isValidEvent(servletName, appName, hostName)) {
            this.timeStatDataLocal.get().setEntryTime(System.currentTimeMillis());
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Servlet before service event received - servletName = " + servletName + ": appName = " + appName + ": hostName = " + hostName);
            }
        }
    }

    @ProbeListener(value="glassfish:web:servlet:afterServiceEvent")
    public void afterServiceEvent(@ProbeParam(value="servletName") String servletName, @ProbeParam(value="responseStatus") int responseStatus, @ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName) {
        if (this.isValidEvent(servletName, appName, hostName)) {
            TimeStatData tsd = this.timeStatDataLocal.get();
            tsd.setExitTime(System.currentTimeMillis());
            long servletProcessingTime = tsd.getTotalTime();
            this.requestProcessTime.incrementCount(servletProcessingTime);
            this.servletStatsProvider.addServletProcessingTime(servletProcessingTime);
            if (responseStatus >= 400) {
                this.errorCount.increment();
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("Servlet after service event received - servletName = " + servletName + ": appName = " + appName + ": hostName = " + hostName);
            }
        }
    }

    @Reset
    public void reset() {
        this.requestProcessTime.reset();
        this.errorCount.reset();
        this.requestCount.reset();
        this.maxTime.reset();
        this.serviceTime.reset();
        this.processingTime.reset();
    }

    private boolean isValidEvent(String sName, String mName, String hostName) {
        return this.moduleName.equals(mName) && this.vsName.equals(hostName) && this.servletName.equals(sName);
    }
}

