/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.annotation.Annotation;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.grizzly.config.dom.FileCache;
import org.glassfish.grizzly.config.dom.Http;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Protocols;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="create-http")
@PerLookup
@I18n(value="create.http")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTER, CommandTarget.CONFIG})
@RestEndpoints(value={@RestEndpoint(configBean=Protocol.class, opType=RestEndpoint.OpType.POST, path="create-http", description="Create", params={@RestParam(name="id", value="$parent")})})
public class CreateHttp
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateHttp.class);
    @Param(name="protocolname", primary=true)
    String protocolName;
    @Param(name="request-timeout-seconds", optional=true, alias="requestTimeoutSeconds")
    String requestTimeoutSeconds;
    @Param(name="timeout-seconds", defaultValue="30", optional=true, alias="timeoutSeconds")
    String timeoutSeconds;
    @Param(name="max-connection", defaultValue="256", optional=true, alias="maxConnections")
    String maxConnections;
    @Param(name="default-virtual-server", alias="defaultVirtualServer")
    String defaultVirtualServer;
    @Param(name="dns-lookup-enabled", defaultValue="false", optional=true, alias="dnsLookupEnabled")
    Boolean dnsLookupEnabled = false;
    @Param(name="servername", optional=true, alias="serverName")
    String serverName;
    @Param(name="xpowered", optional=true, defaultValue="true", alias="xpoweredBy")
    Boolean xPoweredBy = false;
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Inject
    @Named(value="default-instance-name")
    Config config;
    @Inject
    ServiceLocator services;
    @Inject
    Domain domain;

    public void execute(AdminCommandContext context) {
        Target targetUtil = (Target)this.services.getService(Target.class, new Annotation[0]);
        Config newConfig = targetUtil.getConfig(this.target);
        if (newConfig != null) {
            this.config = newConfig;
        }
        ActionReport report = context.getActionReport();
        Protocols protocols = this.config.getNetworkConfig().getProtocols();
        Protocol protocol = null;
        for (Protocol p : protocols.getProtocol()) {
            if (!this.protocolName.equals(p.getName())) continue;
            protocol = p;
        }
        if (protocol == null) {
            report.setMessage(localStrings.getLocalString("create.http.fail.protocolnotfound", "The specified protocol {0} is not yet configured. Please create one", new Object[]{this.protocolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (protocol.getHttp() != null) {
            report.setMessage(localStrings.getLocalString("create.http.fail.duplicate", "An http element for {0} already exists. Cannot add duplicate http", new Object[]{this.protocolName}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                public Object run(Protocol param) throws TransactionFailure {
                    Http http = (Http)param.createChild(Http.class);
                    FileCache cache = (FileCache)http.createChild(FileCache.class);
                    cache.setEnabled("false");
                    http.setFileCache(cache);
                    http.setDefaultVirtualServer(CreateHttp.this.defaultVirtualServer);
                    http.setDnsLookupEnabled(CreateHttp.this.dnsLookupEnabled == null ? null : CreateHttp.this.dnsLookupEnabled.toString());
                    http.setMaxConnections(CreateHttp.this.maxConnections);
                    http.setRequestTimeoutSeconds(CreateHttp.this.requestTimeoutSeconds);
                    http.setTimeoutSeconds(CreateHttp.this.timeoutSeconds);
                    http.setXpoweredBy(CreateHttp.this.xPoweredBy == null ? null : CreateHttp.this.xPoweredBy.toString());
                    http.setServerName(CreateHttp.this.serverName);
                    param.setHttp(http);
                    return http;
                }
            }, (ConfigBeanProxy)protocol);
        }
        catch (TransactionFailure e) {
            report.setMessage(localStrings.getLocalString("create.http.redirect.fail", "Failed to create http-redirect for {0}: {1}", new Object[]{this.protocolName, e.getMessage() == null ? "No reason given." : e.getMessage()}));
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
            return;
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }
}

