/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.admin.monitor;

import com.sun.grizzly.tcp.RequestInfo;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.external.probe.provider.annotations.ProbeListener;
import org.glassfish.external.probe.provider.annotations.ProbeParam;
import org.glassfish.external.statistics.CountStatistic;
import org.glassfish.external.statistics.annotations.Reset;
import org.glassfish.external.statistics.impl.CountStatisticImpl;
import org.glassfish.external.statistics.impl.TimeStatisticImpl;
import org.glassfish.gmbal.AMXMetadata;
import org.glassfish.gmbal.Description;
import org.glassfish.gmbal.ManagedAttribute;
import org.glassfish.gmbal.ManagedObject;
import org.glassfish.web.admin.monitor.TimeStatData;

@AMXMetadata(type="web-request-mon", group="monitoring")
@ManagedObject
@Description(value="Web Request Statistics")
public class RequestStatsProvider {
    private static final Logger logger = LogDomains.getLogger(RequestStatsProvider.class, (String)"javax.enterprise.system.container.web");
    private static final String ERROR_COUNT_DESCRIPTION = "Cumulative value of the error count, with error count representing the number of cases where the response code was greater than or equal to 400";
    private static final String REQUEST_COUNT_DESCRIPTION = "Cumulative number of requests processed so far";
    private static final String MAX_TIME_DESCRIPTION = "Longest response time for a request; not a cumulative value, but the largest response time from among the response times";
    private static final String PROCESSING_TIME_DESCRIPTION = "Average request processing time";
    private CountStatisticImpl errorCount = new CountStatisticImpl("ErrorCount", "count", "Cumulative value of the error count, with error count representing the number of cases where the response code was greater than or equal to 400");
    private CountStatisticImpl requestCount = new CountStatisticImpl("RequestCount", "count", "Cumulative number of requests processed so far");
    private CountStatisticImpl maxTime = new CountStatisticImpl("MaxTime", "millisecond", "Longest response time for a request; not a cumulative value, but the largest response time from among the response times");
    private CountStatisticImpl processingTime = new CountStatisticImpl("ProcessingTime", "millisecond", "Average request processing time");
    private TimeStatisticImpl requestProcessTime = new TimeStatisticImpl(0L, 0L, 0L, 0L, "", "", "", System.currentTimeMillis(), -1L);
    private String virtualServerName = null;
    private String moduleName = null;
    private ThreadLocal<TimeStatData> timeStatDataLocal = new ThreadLocal<TimeStatData>(){
        TimeStatData tsd;

        @Override
        protected TimeStatData initialValue() {
            this.tsd = new TimeStatData();
            return this.tsd;
        }

        @Override
        public TimeStatData get() {
            if (this.tsd == null) {
                this.tsd = new TimeStatData();
            }
            return this.tsd;
        }
    };

    public RequestStatsProvider(String appName, String vsName) {
        this.virtualServerName = vsName;
        this.moduleName = appName;
    }

    @ManagedAttribute(id="errorcount")
    @Description(value="Cumulative value of the error count, with error count representing the number of cases where the response code was greater than or equal to 400")
    public CountStatistic getErrorCount() {
        return this.errorCount;
    }

    @ManagedAttribute(id="requestcount")
    @Description(value="Cumulative number of requests processed so far")
    public CountStatistic getRequestCount() {
        this.requestCount.setCount(this.requestProcessTime.getCount());
        return this.requestCount;
    }

    @ManagedAttribute(id="maxtime")
    @Description(value="Longest response time for a request; not a cumulative value, but the largest response time from among the response times")
    public CountStatistic getMaxTime() {
        this.maxTime.setCount(this.requestProcessTime.getMaxTime());
        return this.maxTime;
    }

    @ManagedAttribute(id="processingtime")
    @Description(value="Average request processing time")
    public CountStatistic getProcessingTime() {
        long count = this.requestProcessTime.getCount();
        long processTime = 0L;
        if (count != 0L) {
            processTime = this.requestProcessTime.getTotalTime() / count;
        }
        this.processingTime.setCount(processTime);
        return this.processingTime;
    }

    @ProbeListener(value="glassfish:web:http-service:requestStartEvent")
    public void requestStartEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName, @ProbeParam(value="serverName") String serverName, @ProbeParam(value="serverPort") int serverPort, @ProbeParam(value="contextPath") String contextPath, @ProbeParam(value="servletPath") String servletPath) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[TM]requestStartEvent Unprocessed received - virtual-server = " + serverName + ":" + serverPort + ": application = " + contextPath + " : servlet = " + servletPath + " : Expecting (vsName, appName) = (" + this.virtualServerName + ", " + this.moduleName + ")");
        }
        if (this.virtualServerName != null && this.moduleName != null) {
            if (appName != null && hostName != null && hostName.equals(this.virtualServerName) && appName.equals(this.moduleName)) {
                this.timeStatDataLocal.get().setEntryTime(System.currentTimeMillis());
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("[TM]requestStartEvent resolved - virtual-server = " + serverName + ": application = " + contextPath + " :appName = " + appName + " : servlet = " + servletPath + " : port = " + serverPort);
                }
            }
        } else {
            this.timeStatDataLocal.get().setEntryTime(System.currentTimeMillis());
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("[TM]requestStartEvent resolved - virtual-server = " + serverName + ": application = " + contextPath + " : servlet = " + servletPath);
            }
        }
    }

    @ProbeListener(value="glassfish:web:http-service:requestEndEvent")
    public void requestEndEvent(@ProbeParam(value="appName") String appName, @ProbeParam(value="hostName") String hostName, @ProbeParam(value="serverName") String serverName, @ProbeParam(value="serverPort") int serverPort, @ProbeParam(value="contextPath") String contextPath, @ProbeParam(value="servletPath") String servletPath, @ProbeParam(value="statusCode") int statusCode, @ProbeParam(value="method") String method, @ProbeParam(value="uri") String uri, @ProbeParam(value="reqInfo") RequestInfo reqInfo) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("[TM]requestEndEvent Unprocessed received - virtual-server = " + serverName + ": application = " + contextPath + " : servlet = " + servletPath + " :Response code = " + statusCode + " : Expecting (vsName, appName) = (" + this.virtualServerName + ", " + this.moduleName + ")");
        }
        if (this.virtualServerName != null && this.moduleName != null) {
            if (appName != null && hostName != null && hostName.equals(this.virtualServerName) && appName.equals(this.moduleName)) {
                TimeStatData tsd = this.timeStatDataLocal.get();
                tsd.setExitTime(System.currentTimeMillis());
                this.requestProcessTime.incrementCount(tsd.getTotalTime());
                if (statusCode >= 400) {
                    this.errorCount.increment();
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("[TM]requestEndEvent resolved - virtual-server = " + serverName + ": application = " + contextPath + " :appName = " + appName + " : servlet = " + servletPath + " : port = " + serverPort + " :Response code = " + statusCode);
                }
            }
        } else {
            TimeStatData tsd = this.timeStatDataLocal.get();
            tsd.setExitTime(System.currentTimeMillis());
            this.requestProcessTime.incrementCount(tsd.getTotalTime());
            if (statusCode >= 400) {
                this.errorCount.increment();
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("[TM]requestEndEvent resolved - virtual-server = " + serverName + ": application = " + contextPath + " : servlet = " + servletPath + " : port = " + serverPort + " :Response code = " + statusCode);
            }
        }
    }

    public long getProcessTime() {
        return this.requestProcessTime.getTotalTime() / this.requestProcessTime.getCount();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getVSName() {
        return this.virtualServerName;
    }

    @Reset
    public void reset() {
        this.requestProcessTime.reset();
        this.errorCount.reset();
        this.maxTime.reset();
        this.processingTime.reset();
        this.requestCount.reset();
    }
}

