/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.loader;

import com.sun.enterprise.loader.ResourceLocator;
import com.sun.enterprise.security.integration.DDPermissionsLoader;
import com.sun.enterprise.security.integration.PermsHolder;
import com.sun.enterprise.util.io.FileUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import org.apache.naming.JndiPermission;
import org.apache.naming.resources.BaseDirContext;
import org.apache.naming.resources.DirContextURLStreamHandler;
import org.apache.naming.resources.JarFileResourcesProvider;
import org.apache.naming.resources.ProxyDirContext;
import org.apache.naming.resources.Resource;
import org.apache.naming.resources.ResourceAttributes;
import org.apache.naming.resources.WebDirContext;
import org.glassfish.api.deployment.InstrumentableClassLoader;
import org.glassfish.common.util.GlassfishUrlClassLoader;
import org.glassfish.hk2.api.PreDestroy;
import org.glassfish.web.loader.JarFileManager;
import org.glassfish.web.loader.LogFacade;
import org.glassfish.web.loader.ReferenceCleaner;
import org.glassfish.web.loader.Reloader;
import org.glassfish.web.loader.RepositoryManager;
import org.glassfish.web.loader.ResourceEntry;

public final class WebappClassLoader
extends GlassfishUrlClassLoader
implements Reloader,
InstrumentableClassLoader,
DDPermissionsLoader,
JarFileResourcesProvider,
PreDestroy {
    public static final boolean DELEGATE_DEFAULT = true;
    private static final System.Logger LOG;
    private static final Function<String, String> PACKAGE_TO_PATH;
    private static final String WEB_INF_LIB = "/WEB-INF/lib";
    private static final Set<String> DELEGATED_PACKAGES;
    private static final Set<String> DELEGATED_RESOURCE_PATHS;
    private static final SecurityManager SECURITY_MANAGER;
    private final ReferenceCleaner cleaner;
    private final ConcurrentHashMap<String, ResourceEntry> resourceEntryCache = new ConcurrentHashMap();
    private final Set<String> notFoundResources = ConcurrentHashMap.newKeySet();
    private DirContext jndiResources;
    private boolean delegate = true;
    private boolean antiJARLocking;
    private final RepositoryManager repositoryManager = new RepositoryManager();
    private final JarFileManager jarFiles = new JarFileManager();
    private final ConcurrentLinkedQueue<PathTimestamp> pathTimestamps = new ConcurrentLinkedQueue();
    private List<String> jarNames = new ArrayList<String>();
    private boolean packageDefinitionSecurityEnabled;
    private final ConcurrentLinkedQueue<Permission> permissionList = new ConcurrentLinkedQueue();
    private PermsHolder permissionsHolder;
    private File loaderDir;
    private final ConcurrentHashMap<String, PermissionCollection> loaderPC = new ConcurrentHashMap();
    private final ClassLoader system;
    private LifeCycleStatus status = LifeCycleStatus.NEW;
    private boolean hasExternalRepositories;
    private final List<ClassFileTransformer> transformers = new CopyOnWriteArrayList<ClassFileTransformer>();
    private boolean useMyFaces;
    private Set<String> overridablePackages = Set.of();
    private boolean clearReferencesStatic;
    private String contextName = "unknown";
    private List<URL> repositoryURLs;

    public WebappClassLoader(ClassLoader parent) {
        super(new URL[0], parent);
        this.cleaner = new ReferenceCleaner(this);
        this.system = WebappClassLoader.class.getClassLoader();
        if (SECURITY_MANAGER != null) {
            this.refreshPolicy();
        }
        this.permissionsHolder = new PermsHolder();
    }

    public void setDelegate(boolean delegate) {
        this.checkStatus(LifeCycleStatus.NEW, LifeCycleStatus.RUNNING);
        LOG.log(System.Logger.Level.DEBUG, "setDelegate(delegate={0})", delegate);
        this.delegate = delegate;
    }

    public void setOverridablePackages(Set<String> packageNames) {
        this.checkStatus(LifeCycleStatus.NEW, LifeCycleStatus.RUNNING);
        this.overridablePackages = packageNames;
    }

    public void setResources(DirContext resources) {
        DirContext dirCtx;
        LOG.log(System.Logger.Level.DEBUG, "setResources(resources={0})", resources);
        this.checkStatus(LifeCycleStatus.NEW, LifeCycleStatus.RUNNING);
        this.jndiResources = resources;
        if (resources instanceof ProxyDirContext) {
            ProxyDirContext proxyRes = (ProxyDirContext)resources;
            this.contextName = proxyRes.getContextName();
            dirCtx = proxyRes.getDirContext();
        } else {
            dirCtx = resources;
            if (dirCtx instanceof BaseDirContext) {
                this.contextName = new File(((BaseDirContext)dirCtx).getDocBase()).getName();
            }
        }
        if (dirCtx instanceof WebDirContext) {
            ((WebDirContext)dirCtx).setJarFileResourcesProvider((JarFileResourcesProvider)this);
        }
    }

    public void setAntiJARLocking(boolean enable) {
        this.checkStatus(LifeCycleStatus.NEW);
        this.antiJARLocking = enable;
    }

    public void setPackageDefinitionSecurityEnabled(boolean enable) {
        if (enable && SECURITY_MANAGER == null) {
            throw new IllegalArgumentException("The Security Manager is disabled.");
        }
        LOG.log(System.Logger.Level.DEBUG, "setPackageDefinitionSecurityEnabled(enable={0})", enable);
        this.packageDefinitionSecurityEnabled = enable;
    }

    public void addPermission(URL url) {
        this.checkStatus(LifeCycleStatus.NEW, LifeCycleStatus.RUNNING);
        if (url != null) {
            this.addPermission(url.toString());
        }
    }

    public void addPermission(String path) {
        this.checkStatus(LifeCycleStatus.NEW, LifeCycleStatus.RUNNING);
        if (path == null || SECURITY_MANAGER == null) {
            return;
        }
        SECURITY_MANAGER.checkSecurityAccess("createPolicy.eepermissions");
        if (path.startsWith("jndi:") || path.startsWith("jar:jndi:")) {
            Object jndiPath = path.endsWith("/") ? path : path + "/";
            this.permissionList.add((Permission)new JndiPermission((String)jndiPath + "*"));
        } else {
            Object filePath;
            if (path.endsWith(File.separator)) {
                filePath = path;
            } else {
                this.permissionList.add(new FilePermission(path, "read"));
                filePath = path + File.separator;
            }
            this.permissionList.add(new FilePermission((String)filePath + "-", "read"));
        }
    }

    public void addPermission(Permission permission) {
        this.checkStatus(LifeCycleStatus.NEW, LifeCycleStatus.RUNNING);
        if (SECURITY_MANAGER != null && permission != null) {
            SECURITY_MANAGER.checkSecurityAccess("createPolicy.eepermissions");
            this.permissionList.add(permission);
        }
    }

    public void addDeclaredPermissions(PermissionCollection declaredPc) throws SecurityException {
        this.checkStatus(LifeCycleStatus.NEW, LifeCycleStatus.RUNNING);
        if (SECURITY_MANAGER != null) {
            SECURITY_MANAGER.checkSecurityAccess("createPolicy.eepermissions");
            this.permissionsHolder.setDeclaredPermissions(declaredPc);
        }
    }

    public void addEEPermissions(PermissionCollection eePc) throws SecurityException {
        this.checkStatus(LifeCycleStatus.NEW, LifeCycleStatus.RUNNING);
        if (SECURITY_MANAGER != null) {
            SECURITY_MANAGER.checkSecurityAccess("createPolicy.eepermissions");
            this.permissionsHolder.setEEPermissions(eePc);
        }
    }

    public String getLibJarPath() {
        return WEB_INF_LIB;
    }

    public void setWorkDir(File workDir) {
        this.checkStatus(LifeCycleStatus.NEW);
        this.loaderDir = new File(workDir, "loader_" + this.hashCode());
    }

    public void setUseMyFaces(boolean useMyFaces) {
        this.checkStatus(LifeCycleStatus.NEW);
        this.useMyFaces = useMyFaces;
    }

    public void setClearReferencesStatic(boolean clearReferencesStatic) {
        this.checkStatus(LifeCycleStatus.NEW);
        this.clearReferencesStatic = clearReferencesStatic;
    }

    @Override
    public void addRepository(String repository) throws IllegalArgumentException {
        LOG.log(System.Logger.Level.DEBUG, "addRepository(repository={0})", repository);
        this.checkStatus(LifeCycleStatus.NEW, LifeCycleStatus.RUNNING);
        if (repository.startsWith(WEB_INF_LIB) || repository.startsWith("/WEB-INF/classes")) {
            return;
        }
        try {
            super.addURL(new URL(repository));
            this.hasExternalRepositories = true;
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Invalid repository: " + repository, e);
        }
    }

    public void addRepository(String repository, File directory) {
        LOG.log(System.Logger.Level.DEBUG, "addRepository(repository={0}, file={1})", repository, directory);
        this.checkStatus(LifeCycleStatus.NEW);
        this.repositoryManager.addRepository(repository, directory);
    }

    public void addJar(String filePath, File file) {
        LOG.log(System.Logger.Level.DEBUG, "addJar(filePath={0}, file={1})", filePath, file);
        this.checkStatus(LifeCycleStatus.NEW);
        super.addURL(WebappClassLoader.toURL(file));
        if (filePath.startsWith(WEB_INF_LIB)) {
            String jarName = filePath.substring(WEB_INF_LIB.length());
            while (jarName.charAt(0) == '/') {
                jarName = jarName.substring(1);
            }
            this.jarNames.add(jarName);
        }
        try {
            long lastModified = this.getResourceAttributes(filePath).getLastModified();
            this.pathTimestamps.add(new PathTimestamp(filePath, lastModified));
        }
        catch (NamingException e) {
            LOG.log(System.Logger.Level.DEBUG, "Could not get resource attributes from JNDI for " + filePath, (Throwable)e);
        }
        this.jarFiles.addJarFile(file);
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.checkStatus(LifeCycleStatus.NEW, LifeCycleStatus.RUNNING);
        this.transformers.add(transformer);
    }

    public void start() {
        LOG.log(System.Logger.Level.DEBUG, "start()");
        this.checkStatus(LifeCycleStatus.NEW);
        this.jarNames = Collections.unmodifiableList(this.jarNames);
        this.status = LifeCycleStatus.RUNNING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        int i;
        LOG.log(System.Logger.Level.DEBUG, "findClass(name={0})", name);
        this.checkStatus(LifeCycleStatus.RUNNING);
        if (this.packageDefinitionSecurityEnabled && (i = name.lastIndexOf(46)) >= 0) {
            try {
                SECURITY_MANAGER.checkPackageDefinition(name.substring(0, i));
            }
            catch (Exception se) {
                throw new ClassNotFoundException(name, se);
            }
        }
        Class clazz = null;
        try {
            try {
                ResourceEntry entry = this.findClassInternal(name);
                CodeSource codeSource = new CodeSource(entry.codeBase, entry.certificates);
                Object object = this.getClassLoadingLock(name);
                synchronized (object) {
                    if (entry.loadedClass == null) {
                        byte[] binaryContent = entry.binaryContent;
                        if (!this.transformers.isEmpty()) {
                            String internalClassName = name.replace('.', '/');
                            for (ClassFileTransformer transformer : this.transformers) {
                                byte[] transformedBytes = transformer.transform((ClassLoader)((Object)this), internalClassName, null, null, binaryContent);
                                if (transformedBytes == null) continue;
                                binaryContent = transformedBytes;
                                LOG.log(System.Logger.Level.TRACE, "Transformed {0}", internalClassName);
                            }
                        }
                        entry.loadedClass = clazz = this.defineClass(name, binaryContent, 0, binaryContent.length, codeSource);
                        entry.binaryContent = null;
                        entry.source = null;
                        entry.codeBase = null;
                        entry.manifest = null;
                        entry.certificates = null;
                    } else {
                        clazz = entry.loadedClass;
                    }
                }
            }
            catch (IllegalClassFormatException icfe) {
                throw new IllegalStateException("Could not preprocess " + WebappClassLoader.toClassFilePath(name), icfe);
            }
            catch (ClassNotFoundException cnfe) {
                if (!this.hasExternalRepositories) {
                    throw cnfe;
                }
            }
            catch (UnsupportedClassVersionError ucve) {
                throw new UnsupportedClassVersionError(LogFacade.getString("AS-WEB-UTIL-00005", name, this.getJavaVersion()));
            }
            catch (AccessControlException ace) {
                throw new ClassNotFoundException(name, ace);
            }
            catch (Error | RuntimeException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(LogFacade.getString("AS-WEB-UTIL-00006", name, t.toString()), t);
            }
            if (clazz == null && this.hasExternalRepositories) {
                try {
                    clazz = super.findClass(name);
                }
                catch (AccessControlException ace) {
                    throw new ClassNotFoundException(name, ace);
                }
                catch (RuntimeException e) {
                    throw e;
                }
            }
            if (clazz == null) {
                throw new ClassNotFoundException(name);
            }
        }
        catch (ClassNotFoundException e) {
            LOG.log(System.Logger.Level.TRACE, "Rethrowing exception for " + name, (Throwable)e);
            throw e;
        }
        LOG.log(System.Logger.Level.TRACE, "Returning {0}", clazz);
        return clazz;
    }

    public URL findResource(String name) {
        ResourceEntry entry;
        LOG.log(System.Logger.Level.DEBUG, "findResource(name={0})", name);
        this.checkStatus(LifeCycleStatus.RUNNING);
        if (".".equals(name)) {
            name = "";
        }
        if ((entry = this.resourceEntryCache.get(name)) == null) {
            entry = this.findResourceInternal(name, name);
        }
        URL url = null;
        if (entry != null) {
            url = entry.source;
        }
        if (url == null && this.hasExternalRepositories) {
            url = super.findResource(name);
        }
        LOG.log(System.Logger.Level.TRACE, "Returning {0} for name={1}", url, name);
        return url;
    }

    public Enumeration<URL> findResources(String name) throws IOException {
        LOG.log(System.Logger.Level.DEBUG, "findResources(name={0})", name);
        this.checkStatus(LifeCycleStatus.RUNNING);
        if (this.jndiResources == null) {
            return super.findResources(name);
        }
        ArrayList<URL> foundResources = new ArrayList<URL>();
        List<RepositoryManager.RepositoryResource> resources = this.repositoryManager.getResources(name);
        for (RepositoryManager.RepositoryResource resource : resources) {
            try {
                this.jndiResources.lookup(resource.name);
                foundResources.add(WebappClassLoader.toURL(resource.file));
            }
            catch (NamingException namingException) {}
        }
        Enumeration otherResourcePaths = super.findResources(name);
        while (otherResourcePaths.hasMoreElements()) {
            foundResources.add((URL)otherResourcePaths.nextElement());
        }
        return Collections.enumeration(foundResources);
    }

    public URL getResource(String name) {
        URL url;
        LOG.log(System.Logger.Level.DEBUG, "getResource(name={0})", name);
        this.checkStatus(LifeCycleStatus.RUNNING);
        if (this.isDelegateFirstResource(name) && (url = this.getDelegateClassLoader().getResource(name)) != null) {
            LOG.log(System.Logger.Level.TRACE, "Returning {0} for name={1}", url, name);
            return url;
        }
        url = this.findResource(name);
        if (url != null) {
            if (this.antiJARLocking && !name.endsWith(".class") && !name.endsWith(".jar")) {
                ResourceEntry entry = this.resourceEntryCache.get(name);
                try {
                    String repository = entry.codeBase.toString();
                    if (repository.endsWith(".jar")) {
                        File resourceFile = new File(this.loaderDir, name);
                        url = resourceFile.toURI().toURL();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            LOG.log(System.Logger.Level.TRACE, "Returning {0} for name={1}", url, name);
            return url;
        }
        if (!this.delegate && (url = this.getDelegateClassLoader().getResource(name)) != null) {
            LOG.log(System.Logger.Level.TRACE, "Returning {0} for name={1}", url, name);
            return url;
        }
        LOG.log(System.Logger.Level.TRACE, "Resource {0} not found, returning null", name);
        return null;
    }

    public InputStream getResourceAsStream(String name) {
        LOG.log(System.Logger.Level.DEBUG, "getResourceAsStream(name={0})", name);
        this.checkStatus(LifeCycleStatus.RUNNING);
        InputStream stream = this.findLoadedResource(name);
        if (stream != null) {
            return stream;
        }
        if (this.isDelegateFirstResource(name) && (stream = this.getDelegateClassLoader().getResourceAsStream(name)) != null) {
            return stream;
        }
        URL url = this.findResource(name);
        if (url != null) {
            stream = this.findLoadedResource(name);
            try {
                if (this.hasExternalRepositories && stream == null) {
                    stream = url.openStream();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (stream != null) {
                return stream;
            }
        }
        if (!this.delegate && (stream = this.getDelegateClassLoader().getResourceAsStream(name)) != null) {
            return stream;
        }
        LOG.log(System.Logger.Level.TRACE, "Resource {0} not found, returning null", name);
        return null;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        this.checkStatus(LifeCycleStatus.RUNNING);
        ClassLoader loader = this.getDelegateClassLoader();
        ResourceLocator locator = new ResourceLocator((URLClassLoader)((Object)this), loader, this.isDelegateFirstResource(name));
        return locator.getResources(name);
    }

    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name == null) {
            return null;
        }
        LOG.log(System.Logger.Level.DEBUG, "loadClass(name={0}, resolve={1})", name, resolve);
        this.checkStatus(LifeCycleStatus.RUNNING);
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            int i;
            Class<?> clazz = this.findLoadedClass0(name);
            if (clazz != null) {
                return this.resolveIfRequired(resolve, clazz);
            }
            clazz = this.findLoadedClass(name);
            if (clazz != null) {
                return this.resolveIfRequired(resolve, clazz);
            }
            if (this.packageDefinitionSecurityEnabled && (i = name.lastIndexOf(46)) >= 0) {
                try {
                    SECURITY_MANAGER.checkPackageAccess(name.substring(0, i));
                }
                catch (SecurityException se) {
                    String error = LogFacade.getString("AS-WEB-UTIL-00004", name);
                    LOG.log(System.Logger.Level.INFO, error, (Throwable)se);
                    throw new ClassNotFoundException(error, se);
                }
            }
            ClassLoader delegateLoader = this.getDelegateClassLoader();
            boolean delegateLoad = this.isDelegateFirstClass(name);
            if (delegateLoad) {
                try {
                    clazz = delegateLoader.loadClass(name);
                    if (clazz != null) {
                        return this.resolveIfRequired(resolve, clazz);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            try {
                clazz = this.findClass(name);
                if (clazz != null) {
                    return this.resolveIfRequired(resolve, clazz);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            if (!delegateLoad) {
                try {
                    clazz = delegateLoader.loadClass(name);
                    if (clazz != null) {
                        return this.resolveIfRequired(resolve, clazz);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }
        throw new ClassNotFoundException(name);
    }

    public String getName() {
        return this.contextName;
    }

    protected PermissionCollection getPermissions(CodeSource codeSource) {
        PermissionCollection tmpPc;
        LOG.log(System.Logger.Level.TRACE, "getPermissions(codeSource={0})", codeSource);
        this.checkStatus(LifeCycleStatus.RUNNING);
        String codeUrl = codeSource.getLocation().toString();
        PermissionCollection pc = this.loaderPC.get(codeUrl);
        if (pc != null) {
            return pc;
        }
        pc = new Permissions();
        PermissionCollection spc = super.getPermissions(codeSource);
        Enumeration<Permission> permsa = spc.elements();
        while (permsa.hasMoreElements()) {
            Permission p = permsa.nextElement();
            pc.add(p);
        }
        for (Permission p : this.permissionList) {
            pc.add(p);
        }
        PermissionCollection pc1 = this.permissionsHolder.getPermissions(codeSource, null);
        if (pc1 != null) {
            Enumeration<Permission> dperms = pc1.elements();
            while (dperms.hasMoreElements()) {
                Permission p = dperms.nextElement();
                pc.add(p);
            }
        }
        return (tmpPc = this.loaderPC.putIfAbsent(codeUrl, pc)) == null ? pc : tmpPc;
    }

    public synchronized URL[] getURLs() {
        if (this.status == LifeCycleStatus.CLOSED) {
            return new URL[0];
        }
        if (this.repositoryURLs != null) {
            return (URL[])this.repositoryURLs.toArray(URL[]::new);
        }
        ArrayList<Serializable> urls = new ArrayList<Serializable>();
        for (File directory : this.repositoryManager.getDirectories()) {
            urls.add(WebappClassLoader.toURL(directory));
        }
        for (File file : this.jarFiles.getJarRealFiles()) {
            urls.add(WebappClassLoader.toURL(file));
        }
        for (Serializable serializable : super.getURLs()) {
            urls.add(serializable);
        }
        this.repositoryURLs = urls.stream().distinct().collect(Collectors.toList());
        return (URL[])this.repositoryURLs.toArray(URL[]::new);
    }

    public File getExtractedResourcePath(String path) {
        File extractedResource;
        if (this.antiJARLocking) {
            this.jarFiles.extractResources(this.loaderDir, path);
        }
        return (extractedResource = new File(this.loaderDir, path)).exists() ? extractedResource : null;
    }

    public JarFile[] getJarFiles() {
        this.checkStatus(LifeCycleStatus.RUNNING);
        return this.jarFiles.getJarFiles();
    }

    @Override
    public boolean modified() {
        this.checkStatus(LifeCycleStatus.RUNNING);
        if (this.jndiResources == null) {
            return false;
        }
        for (PathTimestamp pathTimestamp : this.pathTimestamps) {
            try {
                long oldLastModified;
                long currentLastModified = this.getResourceAttributes(pathTimestamp.path).getLastModified();
                if (currentLastModified == (oldLastModified = pathTimestamp.timestamp)) continue;
                if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                    LOG.log(System.Logger.Level.DEBUG, "Resource {0} was modified at {1}, old time stamp was {2}.", pathTimestamp.path, Instant.ofEpochMilli(currentLastModified), Instant.ofEpochMilli(oldLastModified));
                }
                return true;
            }
            catch (NamingException e) {
                LOG.log(System.Logger.Level.ERROR, "AS-WEB-UTIL-00001", pathTimestamp.path);
                return true;
            }
        }
        try {
            NameClassPair ncPair;
            int jarNamesLength = this.jarNames.size();
            NamingEnumeration<Binding> bindings = this.jndiResources.listBindings(WEB_INF_LIB);
            int i = 0;
            while (bindings.hasMoreElements() && i < jarNamesLength) {
                ncPair = (NameClassPair)bindings.nextElement();
                String name = ncPair.getName();
                if (!name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                if (!name.equals(this.jarNames.get(i))) {
                    LOG.log(System.Logger.Level.TRACE, "JAR files changed: {0}", name);
                    return true;
                }
                ++i;
            }
            if (bindings.hasMoreElements()) {
                while (bindings.hasMoreElements()) {
                    ncPair = (NameClassPair)bindings.nextElement();
                    String name = ncPair.getName();
                    if (!name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                    LOG.log(System.Logger.Level.TRACE, "Additional JARs have been added: {0}", name);
                    return true;
                }
            } else if (i < jarNamesLength) {
                LOG.log(System.Logger.Level.TRACE, "Some JAR file was removed.");
                return true;
            }
        }
        catch (ClassCastException | NamingException e) {
            LOG.log(System.Logger.Level.ERROR, "AS-WEB-UTIL-00002", WEB_INF_LIB, e.getMessage());
        }
        return false;
    }

    public void reload() {
        this.checkStatus(LifeCycleStatus.RUNNING);
        this.jarFiles.closeJarFiles();
    }

    public ClassLoader copy() {
        LOG.log(System.Logger.Level.DEBUG, "copy()");
        PrivilegedAction<URLClassLoader> action = () -> new GlassfishUrlClassLoader(this.getURLs(), this.getParent());
        return AccessController.doPrivileged(action);
    }

    public void close() throws IOException {
        if (this.status == LifeCycleStatus.CLOSED) {
            return;
        }
        LOG.log(System.Logger.Level.INFO, "close(), this:\n{0}", this);
        this.cleaner.clearReferences(this.clearReferencesStatic ? this.resourceEntryCache.values() : null);
        this.status = LifeCycleStatus.CLOSED;
        try {
            super.close();
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.WARNING, "Parent close method failed.", (Throwable)e);
        }
        this.notFoundResources.clear();
        this.resourceEntryCache.clear();
        this.pathTimestamps.clear();
        this.jndiResources = null;
        this.repositoryURLs = null;
        this.hasExternalRepositories = false;
        this.repositoryManager.close();
        this.permissionList.clear();
        this.permissionsHolder = null;
        this.loaderPC.clear();
        this.jarFiles.close();
        if (this.loaderDir != null) {
            WebappClassLoader.deleteDir(this.loaderDir);
        }
        DirContextURLStreamHandler.unbind((ClassLoader)((Object)this));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(4096);
        sb.append(super.toString());
        sb.append("[delegate=").append(this.delegate);
        sb.append(", context=").append(this.contextName);
        sb.append(", status=").append((Object)this.status);
        sb.append(", antiJARLocking=").append(this.antiJARLocking);
        sb.append(", securityManager=").append(SECURITY_MANAGER != null);
        sb.append(", packageDefinitionSecurityEnabled=").append(this.packageDefinitionSecurityEnabled);
        sb.append(", repositories=").append(this.repositoryManager);
        sb.append(", notFound.size=").append(this.notFoundResources.size());
        sb.append(", pathTimestamps.size=").append(this.pathTimestamps.size());
        sb.append(", resourceEntryCache.size=").append(this.resourceEntryCache.size());
        sb.append(']');
        return sb.toString();
    }

    public void preDestroy() {
        LOG.log(System.Logger.Level.TRACE, "preDestroy()");
        try {
            this.close();
        }
        catch (Exception e) {
            throw new IllegalStateException("There were issues with closing " + String.valueOf(this), e);
        }
    }

    private ClassLoader getDelegateClassLoader() {
        ClassLoader parent = this.getParent();
        ClassLoader delegateLoader = parent == null ? this.system : parent;
        return delegateLoader;
    }

    private Class<?> resolveIfRequired(boolean resolve, Class<?> clazz) {
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceEntry findClassInternal(String name) throws ClassNotFoundException {
        LOG.log(System.Logger.Level.TRACE, "findClassInternal(name={0})", name);
        if (!this.validate(name)) {
            throw new ClassNotFoundException(name);
        }
        ResourceEntry entry = this.findResourceInternal(name, WebappClassLoader.toClassFilePath(name));
        if (entry == null) {
            throw new ClassNotFoundException(name);
        }
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Package pkg;
            String packageName;
            if (entry.loadedClass != null) {
                return entry;
            }
            if (entry.binaryContent == null) {
                throw new ClassNotFoundException(name);
            }
            int pos = name.lastIndexOf(46);
            String string = packageName = pos == -1 ? null : name.substring(0, pos);
            if (packageName == null) {
                pkg = null;
            } else {
                pkg = this.getDefinedPackage(packageName);
                if (pkg == null) {
                    if (entry.manifest == null) {
                        this.definePackage(packageName, null, null, null, null, null, null, null);
                    } else {
                        this.definePackage(packageName, entry.manifest, entry.codeBase);
                    }
                }
            }
            if (SECURITY_MANAGER != null && pkg != null) {
                boolean sealCheck;
                if (pkg.isSealed()) {
                    sealCheck = pkg.isSealed(entry.codeBase);
                } else {
                    boolean bl = sealCheck = entry.manifest == null || !this.isPackageSealed(packageName, entry.manifest);
                }
                if (!sealCheck) {
                    throw new SecurityException("Sealing violation loading " + name + ": Package " + packageName + " is sealed.");
                }
            }
            return entry;
        }
    }

    private ResourceEntry findResourceInternal(String name, String path) {
        LOG.log(System.Logger.Level.TRACE, "findResourceInternal(name={0}, path={1})", name, path);
        this.checkStatus(LifeCycleStatus.RUNNING);
        if (name == null || path == null) {
            return null;
        }
        ResourceEntry entry = this.resourceEntryCache.get(name);
        if (entry != null) {
            return entry;
        }
        if (this.notFoundResources.contains(name)) {
            return null;
        }
        entry = this.findResourceInternalFromRepositories(name, path);
        if (entry == null) {
            entry = this.jarFiles.findResource(name, path, this.loaderDir, this.antiJARLocking);
        }
        if (entry == null) {
            this.notFoundResources.add(name);
            return null;
        }
        ResourceEntry alreadyPresentEntry = this.resourceEntryCache.putIfAbsent(name, entry);
        return alreadyPresentEntry == null ? entry : alreadyPresentEntry;
    }

    private ResourceEntry findResourceInternalFromRepositories(String name, String path) {
        LOG.log(System.Logger.Level.TRACE, "findResourceInternalFromRepositories(name={0}, path={1})", name, path);
        if (this.jndiResources == null) {
            return null;
        }
        for (RepositoryManager.RepositoryResource repoResource : this.repositoryManager.getResources(path)) {
            try {
                Object lookupResult = this.jndiResources.lookup(repoResource.name);
                if (lookupResult instanceof Resource) {
                    return this.toResourceEntry(name, repoResource, (Resource)lookupResult);
                }
                if (!(lookupResult instanceof WebDirContext)) continue;
                ResourceAttributes attributes = this.getResourceAttributes(repoResource.name);
                return this.toResourceEntry(name, repoResource, attributes);
            }
            catch (NamingException namingException) {
            }
        }
        return null;
    }

    private ResourceEntry toResourceEntry(String name, RepositoryManager.RepositoryResource repoResource, Resource resource) throws NamingException {
        ResourceAttributes attributes = this.getResourceAttributes(repoResource.name);
        ResourceEntry entry = this.toResourceEntry(name, repoResource, attributes);
        int contentLength = (int)attributes.getContentLength();
        try (InputStream binaryStream = resource.streamContent();){
            if (binaryStream != null) {
                entry.readEntryData(name, binaryStream, contentLength, null);
            }
        }
        catch (IOException e) {
            LOG.log(System.Logger.Level.DEBUG, "Could not read entry data for " + name, (Throwable)e);
            return null;
        }
        return entry;
    }

    private ResourceEntry toResourceEntry(String name, RepositoryManager.RepositoryResource repoResource, ResourceAttributes attributes) {
        ResourceEntry entry;
        if (SECURITY_MANAGER == null) {
            entry = new ResourceEntry(WebappClassLoader.toURL(repoResource.file));
        } else {
            PrivilegedAction<ResourceEntry> action = () -> new ResourceEntry(WebappClassLoader.toURL(repoResource.file));
            entry = AccessController.doPrivileged(action);
        }
        entry.lastModified = attributes.getLastModified();
        this.pathTimestamps.add(new PathTimestamp(repoResource.name, entry.lastModified));
        return entry;
    }

    private ResourceAttributes getResourceAttributes(String fullPath) throws NamingException {
        return (ResourceAttributes)this.jndiResources.getAttributes(fullPath);
    }

    private boolean isPackageSealed(String name, Manifest man) {
        String path = name.replace('.', '/') + "/";
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    private InputStream findLoadedResource(String name) {
        ResourceEntry entry = this.resourceEntryCache.get(name);
        if (entry != null && entry.binaryContent != null) {
            return new ByteArrayInputStream(entry.binaryContent);
        }
        return null;
    }

    private Class<?> findLoadedClass0(String name) {
        ResourceEntry entry = this.resourceEntryCache.get(name);
        if (entry != null) {
            return entry.loadedClass;
        }
        return null;
    }

    private void refreshPolicy() {
        try {
            Policy policy = Policy.getPolicy();
            policy.refresh();
        }
        catch (AccessControlException e) {
            LOG.log(System.Logger.Level.TRACE, "The policy refresh failed.", (Throwable)e);
        }
    }

    private boolean validate(String name) {
        if (name == null) {
            return false;
        }
        return !name.startsWith("java.");
    }

    private static URL toURL(File file) {
        File realFile;
        try {
            realFile = file.getCanonicalFile();
        }
        catch (IOException e) {
            realFile = file;
        }
        try {
            return realFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Could not convert " + String.valueOf(file) + " to URL!", e);
        }
    }

    private static void deleteDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (String fileName : files) {
            File file = new File(dir, fileName);
            if (file.isDirectory()) {
                WebappClassLoader.deleteDir(file);
                continue;
            }
            if (FileUtils.deleteFileMaybe((File)file)) continue;
            LOG.log(System.Logger.Level.WARNING, "AS-WEB-UTIL-00024", file);
        }
        if (!FileUtils.deleteFileMaybe((File)dir)) {
            LOG.log(System.Logger.Level.WARNING, "AS-WEB-UTIL-00024", dir);
        }
    }

    private String getJavaVersion() {
        if (SECURITY_MANAGER == null) {
            return System.getProperty("java.version");
        }
        PrivilegedAction<String> action = () -> System.getProperty("java.version");
        return AccessController.doPrivileged(action);
    }

    private boolean isDelegateFirstClass(String className) {
        if (this.delegate) {
            return true;
        }
        if (className.startsWith("java.")) {
            return true;
        }
        String packageName = WebappClassLoader.getPackageName(className);
        if (this.overridablePackages.stream().anyMatch(packageName::startsWith)) {
            return false;
        }
        if (className.startsWith("jakarta.faces.")) {
            return !this.useMyFaces;
        }
        return DELEGATED_PACKAGES.stream().anyMatch(packageName::startsWith);
    }

    private boolean isDelegateFirstResource(String name) {
        if (this.delegate) {
            return true;
        }
        if (name.startsWith("java/")) {
            return true;
        }
        if (this.overridablePackages.stream().map(PACKAGE_TO_PATH).anyMatch(name::startsWith)) {
            return false;
        }
        if (name.startsWith("jakarta/faces/")) {
            return !this.useMyFaces;
        }
        return DELEGATED_RESOURCE_PATHS.stream().anyMatch(name::startsWith);
    }

    private void checkStatus(LifeCycleStatus ... expected) {
        for (LifeCycleStatus expectedStatus : expected) {
            if (this.status != expectedStatus) continue;
            return;
        }
        throw new IllegalStateException("ClassLoader is not in expected state: " + String.valueOf(this));
    }

    private static String toClassFilePath(String name) {
        return name.replace('.', '/') + ".class";
    }

    private static String getPackageName(String className) {
        int pos = className.lastIndexOf(46);
        if (pos == -1) {
            return "";
        }
        return className.substring(0, pos);
    }

    static {
        WebappClassLoader.registerAsParallelCapable();
        LOG = LogFacade.getSysLogger(WebappClassLoader.class);
        PACKAGE_TO_PATH = pkg -> pkg.replace('.', '/');
        DELEGATED_PACKAGES = Set.of("jakarta", "javax", "sun", "org.xml.sax", "org.w3c.dom", "org.glassfish.wasp.standard", "com.sun.faces");
        DELEGATED_RESOURCE_PATHS = DELEGATED_PACKAGES.stream().map(PACKAGE_TO_PATH).collect(Collectors.toUnmodifiableSet());
        SECURITY_MANAGER = System.getSecurityManager();
    }

    private static enum LifeCycleStatus {
        NEW,
        RUNNING,
        CLOSED;

    }

    private static class PathTimestamp {
        final String path;
        final long timestamp;

        PathTimestamp(String path, long timestamp) {
            this.path = path;
            this.timestamp = timestamp;
        }
    }
}

