/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web.runtime;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.types.EjbReference;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Set;

public class ASWebEjbRef
extends WebTest
implements WebCheck {
    @Override
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        Set ejbRefs = descriptor.getEjbReferenceDescriptors();
        if (ejbRefs != null && ejbRefs.size() > 0) {
            for (EjbReference ejbRef : ejbRefs) {
                String refName = ejbRef.getName();
                if (this.validEjbRefName(refName, descriptor)) {
                    this.addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "PASSED [AS-WEB ejb-ref] ejb-ref-name [ {0} ] properly defined in the war file.", new Object[]{refName}));
                    continue;
                }
                oneFailed = true;
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "FAILED [AS-WEB ejb-ref] ejb-ref-name [ {0} ] is not valid, either empty or not defined in web.xml.", new Object[]{refName}));
            }
        } else {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "NOT APPLICABLE [AS-WEB sun-web-app] ejb-ref element(s) not defined in the web archive [ {0} ].", new Object[]{descriptor.getName()}));
            return result;
        }
        if (oneFailed) {
            result.setStatus(1);
        } else {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed2", "PASSED [AS-WEB sun-web-app] ejb-ref element(s) defined are valid within the web archive [ {0} ].", new Object[]{descriptor.getName()}));
        }
        return result;
    }

    boolean validEjbRefName(String name, WebBundleDescriptor descriptor) {
        boolean valid = true;
        if (name != null && name.length() != 0) {
            try {
                descriptor.getEjbReferenceByName(name);
            }
            catch (IllegalArgumentException e) {
                valid = false;
            }
        } else {
            valid = false;
        }
        return valid;
    }
}

