/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;
import org.glassfish.web.deployment.descriptor.SecurityConstraintImpl;

public class WebResourceHTTPMethod
extends WebTest
implements WebCheck {
    @Override
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor.getSecurityConstraints().hasMoreElements()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            int na = 0;
            int noSc = 0;
            int naWRC = 0;
            int noWRC = 0;
            Enumeration e = descriptor.getSecurityConstraints();
            while (e.hasMoreElements()) {
                foundIt = false;
                ++noSc;
                SecurityConstraintImpl securityConstraintImpl = (SecurityConstraintImpl)e.nextElement();
                if (!securityConstraintImpl.getWebResourceCollections().isEmpty()) {
                    for (WebResourceCollection webResourceCollection : securityConstraintImpl.getWebResourceCollections()) {
                        ++noWRC;
                        if (!webResourceCollection.getHttpMethods().isEmpty()) {
                            for (String webRCHTTPMethod : webResourceCollection.getHttpMethods()) {
                                foundIt = webRCHTTPMethod.equals("OPTIONS") || webRCHTTPMethod.equals("GET") || webRCHTTPMethod.equals("HEAD") || webRCHTTPMethod.equals("POST") || webRCHTTPMethod.equals("PUT") || webRCHTTPMethod.equals("DELETE") || webRCHTTPMethod.equals("TRACE") || webRCHTTPMethod.equals("CONNECT");
                                if (foundIt) {
                                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "http-method [ {0} ] is valid HTTP method name within web resource collection [ {1} ] in web application [ {2} ]", new Object[]{webRCHTTPMethod, webResourceCollection.getName(), descriptor.getName()}));
                                    continue;
                                }
                                if (!oneFailed) {
                                    oneFailed = true;
                                }
                                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: http-method [ {0} ] is not valid HTTP method name within web resource collection [ {1} ] in web application [ {2} ]", new Object[]{webRCHTTPMethod, webResourceCollection.getName(), descriptor.getName()}));
                            }
                            continue;
                        }
                        result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "There are no web http-methods in the web resource collection [ {0} ] within [ {1} ]", new Object[]{webResourceCollection.getName(), descriptor.getName()}));
                        ++naWRC;
                    }
                    continue;
                }
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "There are no web web resource collections in the web security constraint within [ {0} ]", new Object[]{descriptor.getName()}));
                ++na;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (na == noSc || naWRC == noWRC) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no http-method elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

