/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.io.File;
import java.util.Iterator;
import java.util.Set;

public class JspFile
extends WebTest
implements WebCheck {
    @Override
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!descriptor.getJspDescriptors().isEmpty()) {
            boolean oneFailed = false;
            boolean foundIt = false;
            FileArchive arch = null;
            Set jsps = descriptor.getJspDescriptors();
            Iterator itr = jsps.iterator();
            while (itr.hasNext()) {
                String uri;
                String jspFilename;
                block13: {
                    foundIt = false;
                    WebComponentDescriptor jsp = (WebComponentDescriptor)itr.next();
                    jspFilename = jsp.getWebComponentImplementation();
                    uri = null;
                    try {
                        File jspf;
                        uri = this.getAbstractArchiveUri(descriptor);
                        arch = new FileArchive();
                        arch.open(uri);
                        if (jspFilename.startsWith("/")) {
                            jspFilename = jspFilename.substring(1);
                        }
                        if ((jspf = new File(new File(arch.getURI()), jspFilename)).exists()) {
                            foundIt = true;
                        }
                        jspf = null;
                    }
                    catch (Exception e) {
                        if (oneFailed) break block13;
                        oneFailed = true;
                    }
                }
                if (foundIt) {
                    result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Jsp file [ {0} ] contains the full path to Jsp file within web application [ {1} ]", new Object[]{jspFilename, descriptor.getName()}));
                    continue;
                }
                if (!oneFailed) {
                    oneFailed = true;
                }
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Jsp file [ {0} ] is not found within [ {1} ] or does not contain the full path to Jsp file within web application [ {2} ]", new Object[]{jspFilename, uri, descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no Jsp components within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

