/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.persistence;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import java.io.File;
import java.util.ArrayList;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.ModuleDescriptor;
import org.glassfish.deployment.common.RootDeploymentDescriptor;

public class JarNotFound
extends VerifierTest
implements VerifierCheck {
    @Override
    public Result check(Descriptor descriptor) {
        Result result = this.getInitializedResult();
        result.setStatus(0);
        this.addErrorDetails(result, this.getVerifierContext().getComponentNameConstructor());
        PersistenceUnitDescriptor pu = (PersistenceUnitDescriptor)PersistenceUnitDescriptor.class.cast(descriptor);
        File absolutePURootFile = this.getAbsolutePuRootFile(pu);
        this.logger.fine("Absolute PU Root: " + absolutePURootFile);
        String absolutePuRoot = absolutePURootFile.getAbsolutePath();
        ArrayList jarFileNames = new ArrayList(pu.getJarFiles());
        for (String jarFileName : jarFileNames) {
            String nativeJarFileName = jarFileName.replace('/', File.separatorChar);
            File parentFile = new File(absolutePuRoot).getParentFile();
            File jarFile = new File(parentFile, nativeJarFileName);
            if (jarFile.exists()) continue;
            String pathComponent = "";
            String nameComponent = jarFileName;
            if (jarFileName.lastIndexOf("../") != -1) {
                int separatorIndex = jarFileName.lastIndexOf("../") + 3;
                pathComponent = jarFileName.substring(0, separatorIndex);
                nameComponent = jarFileName.substring(separatorIndex);
            }
            this.logger.fine("For jar-file=" + jarFileName + ", pathComponent=" + pathComponent + ", nameComponent=" + nameComponent);
            File parentPath = new File(parentFile, pathComponent);
            jarFile = new File(parentPath, DeploymentUtils.getRelativeEmbeddedModulePath((String)parentPath.getAbsolutePath(), (String)nameComponent));
            if (jarFile.exists()) continue;
            result.failed(smh.getLocalString(this.getClass().getName() + "failed", "[ {0} ] specified in persistence.xml does not exist in the application.", new Object[]{jarFileName}));
        }
        return result;
    }

    private File getAbsolutePuRootFile(PersistenceUnitDescriptor persistenceUnitDescriptor) {
        String applicationLocation = this.getVerifierContext().getAbstractArchive().getURI().getPath();
        File absolutePuRootFile = new File(applicationLocation, this.getAbsolutePuRoot(applicationLocation, persistenceUnitDescriptor).replace('/', File.separatorChar));
        if (!absolutePuRootFile.exists()) {
            throw new RuntimeException(absolutePuRootFile.getAbsolutePath() + " does not exist!");
        }
        return absolutePuRootFile;
    }

    private String getAbsolutePuRoot(String applicationLocation, PersistenceUnitDescriptor persistenceUnitDescriptor) {
        RootDeploymentDescriptor rootDD = persistenceUnitDescriptor.getParent().getParent();
        String puRoot = persistenceUnitDescriptor.getPuRoot();
        if (rootDD.isApplication()) {
            return puRoot;
        }
        ModuleDescriptor module = ((BundleDescriptor)BundleDescriptor.class.cast(rootDD)).getModuleDescriptor();
        if (module.isStandalone()) {
            return puRoot;
        }
        String moduleLocation = DeploymentUtils.getRelativeEmbeddedModulePath((String)applicationLocation, (String)module.getArchiveUri());
        return moduleLocation + '/' + puRoot;
    }
}

