/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;

public abstract class InterfaceClassExist
extends EjbTest
implements EjbCheck {
    protected abstract String getInterfaceName(EjbDescriptor var1);

    protected abstract String getInterfaceType();

    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfaceClassExist.notApplicable1", "Test apply only to session or entity beans."));
            return result;
        }
        if (this.getInterfaceName(descriptor) == null || "".equals(this.getInterfaceName(descriptor))) {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfaceClassExist.notApplicable2", "Not Applicable because, EJB [ {0} ] does not have {1} Interface.", new Object[]{descriptor.getEjbClassName(), this.getInterfaceType()}));
            return result;
        }
        try {
            ClassLoader jcl = this.getVerifierContext().getClassLoader();
            Class<?> c = Class.forName(this.getClassName(descriptor), false, jcl);
            if (!c.isInterface()) {
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfaceClassExist.failed", "[ {0} ] is defined as a class. It should be an interface.", new Object[]{this.getClassName(descriptor)}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: " + this.getInterfaceType() + " interface [ {0} ] does not exist or is not loadable.", new Object[]{this.getClassName(descriptor)}));
        }
        if (result.getStatus() != 1) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", this.getInterfaceType() + " interface [ {0} ] exist and is loadable.", new Object[]{this.getClassName(descriptor)}));
        }
        return result;
    }

    private String getClassName(EjbDescriptor descriptor) {
        return this.getInterfaceName(descriptor);
    }
}

