/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.packaging;

import com.sun.enterprise.tools.verifier.apiscan.packaging.ExtensionRef;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Archive {
    private Manifest manifest;
    private File path;
    private static String resourceBundleName = "com.sun.enterprise.tools.verifier.apiscan.LocalStrings";
    private static Logger logger = Logger.getLogger("apiscan.archive", resourceBundleName);
    private static final String myClassName = "Archive";
    private static Archive[] allOptPkgsInstalledInJRE;
    private static String thisClassName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Archive[] getAllOptPkgsInstalledInJRE() {
        if (allOptPkgsInstalledInJRE != null) {
            return allOptPkgsInstalledInJRE;
        }
        Class<Archive> clazz = Archive.class;
        synchronized (Archive.class) {
            if (allOptPkgsInstalledInJRE == null) {
                final ArrayList allPkgs = new ArrayList();
                List ext_dirs = Archive.listAllExtDirs();
                Iterator iter = ext_dirs.iterator();
                while (iter.hasNext()) {
                    File ext_dir = new File((String)iter.next());
                    ext_dir.listFiles(new FileFilter(){

                        @Override
                        public boolean accept(File f) {
                            if (!f.isDirectory()) {
                                try {
                                    allPkgs.add(new Archive(new JarFile(f)));
                                    logger.logp(Level.FINE, Archive.myClassName, "getAllOptPkgsInstalledInJRE", "Found an installed opt pkg " + f.getAbsolutePath());
                                    return true;
                                }
                                catch (Exception e) {
                                    logger.logp(Level.INFO, Archive.myClassName, "getAllOptPkgsInstalledInJRE", thisClassName + ".exception1", new Object[]{f.toString()});
                                    logger.log(Level.INFO, "", e);
                                }
                            }
                            return false;
                        }
                    });
                }
                Archive[] tmp = new Archive[allPkgs.size()];
                allPkgs.toArray(tmp);
                allOptPkgsInstalledInJRE = tmp;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return allOptPkgsInstalledInJRE;
        }
    }

    private static List listAllExtDirs() {
        String ext_dirStr = new String(System.getProperty("java.ext.dirs"));
        logger.fine("Extension Dir Path is " + ext_dirStr);
        ArrayList<String> ext_dirs = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(ext_dirStr, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            ext_dirs.add(next);
        }
        return ext_dirs;
    }

    public Archive(JarFile jar) throws IOException {
        this.manifest = jar.getManifest();
        this.path = new File(jar.getName());
    }

    public Archive(File path) throws IOException {
        this.path = path.getCanonicalFile();
    }

    public String getClassPath() throws IOException {
        String cp = this.getManifest().getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (cp != null) {
            return cp;
        }
        return "";
    }

    public synchronized Manifest getManifest() throws IOException {
        if (this.manifest == null) {
            if (this.path.isDirectory()) {
                File file = new File(this.path.getPath() + File.separator + "META-INF/MANIFEST.MF");
                if (file.exists()) {
                    FileInputStream mis = new FileInputStream(file);
                    this.manifest = new Manifest(mis);
                    ((InputStream)mis).close();
                }
            } else {
                try (JarFile jar = new JarFile(this.path);){
                    this.manifest = jar.getManifest();
                }
            }
            if (this.manifest == null) {
                this.manifest = new Manifest();
            }
        }
        return this.manifest;
    }

    public String getPath() {
        return this.path.getAbsolutePath();
    }

    public Archive[] getBundledArchives() throws IOException {
        ArrayList<Archive> list = new ArrayList<Archive>();
        String parent = this.path.getParent() + File.separator;
        StringTokenizer st = new StringTokenizer(this.getClassPath());
        while (st.hasMoreTokens()) {
            String nextEntry = st.nextToken();
            String entryPath = parent + nextEntry;
            if (!new File(entryPath).exists()) {
                logger.logp(Level.FINE, myClassName, "getBundledArchives", entryPath + " does not exist, will try to see if this is a module whose name has been changed when archive was exploded.");
                String newNextEntry = nextEntry.startsWith("./") && nextEntry.length() > 2 ? nextEntry.substring("./".length()).replaceAll("\\.", "_") : nextEntry.replaceAll("\\.", "_");
                if (new File(parent, newNextEntry).exists()) {
                    logger.logp(Level.FINE, myClassName, "getBundledArchives", "Using " + newNextEntry + " instead of " + nextEntry);
                    entryPath = parent + newNextEntry;
                    list.add(new Archive(new File(entryPath)));
                } else {
                    logger.logp(Level.WARNING, myClassName, "getBundledArchives", thisClassName + ".error1", new Object[]{this.getPath(), nextEntry});
                }
            }
            list.add(new Archive(new File(entryPath)));
        }
        return list.toArray(new Archive[0]);
    }

    public ExtensionRef[] getExtensionRefs() throws IOException {
        ExtensionRef[] refs = new ExtensionRef[]{};
        Manifest manifest = this.getManifest();
        String extensions = manifest.getMainAttributes().getValue(Attributes.Name.EXTENSION_LIST);
        ArrayList<ExtensionRef> extensionList = new ArrayList<ExtensionRef>();
        if (extensions != null) {
            StringTokenizer st = new StringTokenizer(extensions);
            while (st.hasMoreTokens()) {
                String extName = st.nextToken();
                ExtensionRef ref = new ExtensionRef(manifest, extName);
                extensionList.add(ref);
            }
        }
        refs = extensionList.toArray(refs);
        return refs;
    }

    public String toString() {
        return this.getPath();
    }

    static {
        thisClassName = "com.sun.enterprise.tools.verifier.apiscan.packaging.Archive";
    }
}

