/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSSchemaLocation
extends WSTest
implements WSCheck {
    String myValue = null;
    String[] reqSchemaLocation = new String[]{"http://java.sun.com/xml/ns/j2ee http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/javaee_web_services_1_2.xsd", "http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/javaee_web_services_1_3.xsd"};
    int i;

    @Override
    public Result check(WebServiceEndpoint descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        String[] reqSchemaLocationSub1 = new String[]{"http://java.sun.com/xml/ns/j2ee", "http://java.sun.com/xml/ns/javaee"};
        String[] reqSchemaLocationSub2 = new String[]{"http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd", "http://java.sun.com/xml/ns/javaee/javaee_web_services_1_2.xsd", "http://java.sun.com/xml/ns/javaee/javaee_web_services_1_3.xsd"};
        boolean rslt = false;
        String schemaVersion = this.getVerifierContext().getSchemaVersion();
        Document wsdoc = this.getVerifierContext().getWebServiceDocument();
        if (wsdoc == null && schemaVersion.compareTo("1.1") > 0) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "Webservices deployment descriptor is not defined for this archive"));
            return result;
        }
        try {
            if (wsdoc.getDocumentElement().hasAttributes()) {
                this.getNode(wsdoc);
                if (this.myValue != null) {
                    this.i = 0;
                    while (this.i < this.reqSchemaLocation.length && !(rslt = this.verifySchema(this.myValue, this.reqSchemaLocation[this.i], reqSchemaLocationSub1[this.i], reqSchemaLocationSub2[this.i]))) {
                        ++this.i;
                    }
                } else {
                    rslt = true;
                }
            }
            if (rslt) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "The schemaLocation in the webservices.xml file for [{0}] matches the schema file requirement", new Object[]{compName.toString()}));
            } else {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The schemaLocation in the webservices.xml file for [{0}] does not match the schema file requirement", new Object[]{compName.toString()}));
            }
        }
        catch (Exception e) {
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "The schemaLocation in the webservices.xml file for [{0}] does not match the schema file requirement", new Object[]{compName.toString()}));
            result.addErrorDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.Error", "Error: Unexpected error occurred [ {0} ]", new Object[]{e.getMessage()}));
        }
        return result;
    }

    private boolean verifySchema(String nodeval, String reqSchemaLocation, String reqSchemaLocationSub1, String reqSchemaLocationSub2) {
        try {
            int off1 = reqSchemaLocation.indexOf("http", reqSchemaLocationSub1.length());
            int off2 = nodeval.indexOf("http", reqSchemaLocationSub1.length());
            if (!this.checkSubString(nodeval, 0, 0, reqSchemaLocationSub1.length()) || !this.checkSubString(nodeval, off1, off2, reqSchemaLocationSub2.length())) {
                return false;
            }
            if (reqSchemaLocation.length() > nodeval.length()) {
                return false;
            }
            for (int i = reqSchemaLocationSub1.length(); i < off2; ++i) {
                if (Character.isWhitespace(nodeval.charAt(i))) continue;
                return false;
            }
        }
        catch (Exception e) {
            e.toString();
            e.printStackTrace();
        }
        return true;
    }

    private boolean checkSubString(String str, int off1, int off2, int len) {
        return this.reqSchemaLocation[this.i].regionMatches(off1, str, off2, len);
    }

    public void getNode(Node node) {
        Node nextNode;
        String name = node.getNodeName();
        short myType = node.getNodeType();
        if (myType == 1 & name.equals("webservices")) {
            Element e = (Element)node;
            this.myValue = e.getAttribute("xsi:schemaLocation");
            return;
        }
        if (node.hasChildNodes()) {
            Node firstChild = node.getFirstChild();
            this.getNode(firstChild);
        }
        if ((nextNode = node.getNextSibling()) != null) {
            this.getNode(nextNode);
        }
    }
}

