/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Modifier;
import java.util.Set;
import java.util.logging.Level;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;

public abstract class InterfacePublic
extends EjbTest
implements EjbCheck {
    protected abstract Set<String> getInterfaceNames(EjbDescriptor var1);

    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return result;
        }
        String assertionClass = "com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfacePublic";
        for (String intfName : this.getInterfaceNames(descriptor)) {
            try {
                ClassLoader jcl = this.getVerifierContext().getClassLoader();
                Class<?> c = Class.forName(intfName, false, jcl);
                if (Modifier.isPublic(c.getModifiers())) continue;
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(assertionClass + ".failed", "Error: [ {0} ] is not defined as a public interface.", new Object[]{intfName}));
            }
            catch (ClassNotFoundException e) {
                this.logger.log(Level.FINER, e.getMessage(), e);
            }
        }
        if (result.getStatus() != 1) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(assertionClass + ".passed", "Valid public interface(s)."));
        }
        return result;
    }
}

