/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.findermethod;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public class HomeInterfaceFindMethodReturn
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if ("Bean".equals(persistence)) {
                boolean oneFailed = false;
                if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName()) && descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                    oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor.getRemoteClassName(), descriptor);
                }
                if (!(oneFailed || descriptor.getLocalClassName() == null || "".equals(descriptor.getLocalClassName()) || descriptor.getLocalHomeClassName() == null || "".equals(descriptor.getLocalHomeClassName()))) {
                    oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor.getLocalClassName(), descriptor);
                }
                if (oneFailed) {
                    this.result.setStatus(1);
                } else {
                    this.result.setStatus(0);
                }
                return this.result;
            }
            this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{"Bean", descriptor.getName(), persistence}));
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, String remote, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            VerifierTestContext context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> c = Class.forName(home, false, this.getVerifierContext().getClassLoader());
            Class<?> rc = Class.forName(remote, false, this.getVerifierContext().getClassLoader());
            Method[] methods = c.getDeclaredMethods();
            boolean validReturn = false;
            for (int i = 0; i < methods.length; ++i) {
                validReturn = false;
                if (!methods[i].getName().startsWith("find")) continue;
                Class<?> methodReturnType = methods[i].getReturnType();
                validReturn = methodReturnType.getName().equals(rc.getName()) || methodReturnType.getName().equals("java.util.Collection") || methodReturnType.getName().equals("java.util.Enumeration");
                if (validReturn) {
                    this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c.getName(), methods[i].getName()}));
                    this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The find<METHOD> which returns remote interface or a collection there of was found."));
                    continue;
                }
                if (validReturn) continue;
                oneFailed = true;
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c.getName(), methods[i].getName()}));
                this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: A find<METHOD> was found, but the return type [ {0} ] was not the Remote interface [ {1} ] or a collection there of.", new Object[]{methodReturnType.getName(), rc.getName()}));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] or Remote interface [ {1} ] does not exist or is not loadable within bean [ {2} ]", new Object[]{home, remote, descriptor.getName()}));
            return oneFailed;
        }
    }
}

