/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.createmethod;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Level;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public class HomeInterfaceCreateMethodExceptionMatch
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;
    boolean foundAtLeastOneCreate = false;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        if (descriptor instanceof EjbEntityDescriptor) {
            oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor.getLocalHomeClassName(), descriptor);
            if (!this.foundAtLeastOneCreate) {
                this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".debug4", "In Home Interface ", new Object[0]));
                this.result.addNaDetails(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "No create method was found, test not applicable."));
                this.result.setStatus(3);
            } else if (oneFailed) {
                this.result.setStatus(1);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String component, String local, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        int ejbCreateMethodLoopCounter = 0;
        try {
            int i;
            Method[] homeMethods;
            Class<?> home;
            boolean ejbCreateFound = false;
            boolean exceptionsMatch = false;
            Vector<Method> createMethodSuffix = new Vector<Method>();
            if (component != null) {
                home = Class.forName(component, false, this.getVerifierContext().getClassLoader());
                homeMethods = home.getDeclaredMethods();
                for (i = 0; i < homeMethods.length; ++i) {
                    if (!homeMethods[i].getName().startsWith("create")) continue;
                    createMethodSuffix.addElement(homeMethods[i]);
                    this.foundAtLeastOneCreate = true;
                }
            }
            if (local != null) {
                home = Class.forName(local, false, this.getVerifierContext().getClassLoader());
                homeMethods = home.getDeclaredMethods();
                for (i = 0; i < homeMethods.length; ++i) {
                    if (!homeMethods[i].getName().startsWith("create")) continue;
                    createMethodSuffix.addElement(homeMethods[i]);
                    this.foundAtLeastOneCreate = true;
                }
            }
            if (!this.foundAtLeastOneCreate) {
                return false;
            }
            Class<?> EJBClass = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
            block4: do {
                Method[] methods = EJBClass.getDeclaredMethods();
                for (i = 0; i < methods.length; ++i) {
                    ejbCreateFound = false;
                    exceptionsMatch = false;
                    if (methods[i].getName().startsWith("ejbCreate")) {
                        String matchSuffix = methods[i].getName().substring(9);
                        for (int k = 0; k < createMethodSuffix.size(); ++k) {
                            Object[] ejbCreateMethodParameterTypes;
                            Object[] methodParameterTypes;
                            if (!matchSuffix.equals(((Method)createMethodSuffix.elementAt(k)).getName().substring(6)) || !Arrays.equals(methodParameterTypes = ((Method)createMethodSuffix.elementAt(k)).getParameterTypes(), ejbCreateMethodParameterTypes = methods[i].getParameterTypes())) continue;
                            ejbCreateFound = true;
                            Class[] methodExceptionTypes = ((Method)createMethodSuffix.elementAt(k)).getExceptionTypes();
                            Class[] ejbCreateMethodExceptionTypes = methods[i].getExceptionTypes();
                            if (!RmiIIOPUtils.isEjbFindMethodExceptionsSubsetOfFindMethodExceptions(ejbCreateMethodExceptionTypes, methodExceptionTypes)) continue;
                            exceptionsMatch = true;
                            ejbCreateMethodLoopCounter = k;
                            break;
                        }
                        if (ejbCreateFound && exceptionsMatch) {
                            this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                            this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface Method [ {0} ]", new Object[]{((Method)createMethodSuffix.elementAt(ejbCreateMethodLoopCounter)).getName()}));
                            this.result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "The corresponding [ {0} ] method with matching exceptions was found.", new Object[]{methods[i].getName()}));
                        } else if (ejbCreateFound && !exceptionsMatch) {
                            oneFailed = true;
                            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                            this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface Method [ {0} ]", new Object[]{((Method)createMethodSuffix.elementAt(ejbCreateMethodLoopCounter)).getName()}));
                            this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: No corresponding ejbCreate() method was found, where the exceptions defined by method ejbCreate() are defined within matching create() method."));
                            this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{((Method)createMethodSuffix.elementAt(ejbCreateMethodLoopCounter)).getName()});
                            this.logger.log(Level.FINE, this.getClass().getName() + ".debug3", new Object[]{methods[i].getName(), ((Method)createMethodSuffix.elementAt(ejbCreateMethodLoopCounter)).getName()});
                            continue block4;
                        }
                    }
                    if (oneFailed) continue block4;
                }
            } while ((EJBClass = EJBClass.getSuperclass()) != null && (!ejbCreateFound || !exceptionsMatch));
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home (Local/Remote) interface or bean class [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getEjbClassName(), descriptor.getName()}));
            return oneFailed;
        }
    }
}

