/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.logging.Level;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public class EjbClassImplementsComponentInterface
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbEntityDescriptor) {
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                this.commonToBothInterfaces(descriptor.getRemoteClassName(), (EjbDescriptor)((EjbEntityDescriptor)descriptor));
            }
            if (descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                this.commonToBothInterfaces(descriptor.getLocalClassName(), (EjbDescriptor)((EjbEntityDescriptor)descriptor));
            }
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private void commonToBothInterfaces(String component, EjbDescriptor descriptor) {
        try {
            Class<?> c = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
            Class<?> rc = Class.forName(component, false, this.getVerifierContext().getClassLoader());
            boolean foundOne = false;
            block2: do {
                Class<?>[] interfaces = c.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    this.logger.log(Level.FINE, this.getClass().getName() + ".debug1", new Object[]{interfaces[i].getName()});
                    if (!interfaces[i].getName().equals(rc.getName()) || !(descriptor instanceof EjbEntityDescriptor)) continue;
                    this.result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "Warning: [ {0} ] class implments the enterprise Bean's remote interface [ {1} ].  It is recommended that the enterprise bean class not implement the remote interface to prevent inadvertent passing of this as a method argument or result.  The class must provide no-op implementations of the methods defined in the javax.ejb.EJBObject interface.", new Object[]{descriptor.getEjbClassName(), rc.getName()}));
                    foundOne = true;
                    continue block2;
                }
            } while ((c = c.getSuperclass()) != null);
            if (!foundOne) {
                this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "[ {0} ] does not optionally implement bean class remote interface  [ {1} ]", new Object[]{descriptor.getEjbClassName(), rc.getName()}));
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
        }
    }
}

