/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbSessionDescriptor;

public class BusinessMethodExceptionCheck
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor instanceof EjbSessionDescriptor) {
            if (descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                this.commonToBothInterfaces(descriptor.getRemoteClassName(), descriptor);
            }
            if (descriptor.getLocalClassName() != null && !"".equals(descriptor.getLocalClassName())) {
                this.commonToBothInterfaces(descriptor.getLocalClassName(), descriptor);
            }
        }
        if (this.result.getStatus() != 1 && this.result.getStatus() != 2) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All the exceptions defined in the throws clause of the matching business methods are defined in the throws clause of the method of the remote interface "));
        }
        return this.result;
    }

    private void commonToBothInterfaces(String intf, EjbDescriptor descriptor) {
        try {
            Class<?> intfClass = Class.forName(intf, false, this.getVerifierContext().getClassLoader());
            Class<?> beanClass = Class.forName(descriptor.getEjbClassName(), false, this.getVerifierContext().getClassLoader());
            for (Method remoteMethod : intfClass.getMethods()) {
                Class<?>[] exceptions;
                if (remoteMethod.getDeclaringClass().getName().equals("javax.ejb.EJBObject") || remoteMethod.getDeclaringClass().getName().equals("javax.ejb.EJBLocalObject")) continue;
                Class[] parameterTypes = remoteMethod.getParameterTypes();
                Method method = BusinessMethodExceptionCheck.getMethod(beanClass, remoteMethod.getName(), parameterTypes);
                if (method == null) continue;
                Class<?>[] remoteExceptions = remoteMethod.getExceptionTypes();
                for (Class<?> exception : exceptions = method.getExceptionTypes()) {
                    boolean foundOne = false;
                    for (Class<?> remoteException : remoteExceptions) {
                        if (!remoteException.getName().equals(exception.getName())) continue;
                        foundOne = true;
                        break;
                    }
                    if (foundOne) continue;
                    this.addWarningDetails(this.result, this.compName);
                    this.result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "Not Compatible Exception: A public business method [ {0} ] was found, but according to the EJB specification, all the exceptions defined in the throws clause of the matching method of the session bean class must be defined in the throws clause of the method of the remote interface. Exception [ {1} ] is not defined in the bean's remote interface.", new Object[]{method.getName(), exception.getName()}));
                }
            }
        }
        catch (Exception e) {
            Verifier.debug(e);
            this.addErrorDetails(this.result, this.compName);
            this.result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Remote interface [ {0} ] or bean class [ {1} ] does not exist or is not loadable within bean [ {2} ].", new Object[]{intf, descriptor.getEjbClassName(), descriptor.getName()}));
        }
    }
}

