/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.deployment.io.DescriptorConstants;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipFile;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public class JarContainsXMLFile
extends EjbTest
implements EjbCheck {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (this.getVerifierContext().getJavaEEVersion().compareTo("5") >= 0) {
            result.setStatus(3);
            return result;
        }
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        ZipFile jarFile = null;
        InputStream deploymentEntry = null;
        try {
            String uri = this.getAbstractArchiveUri(descriptor);
            FileArchive arch = new FileArchive();
            arch.open(uri);
            deploymentEntry = arch.getEntry(DescriptorConstants.EJB_DD_ENTRY);
            if (deploymentEntry != null) {
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Found deployment descriptor xml file [ {0} ]", new Object[]{DescriptorConstants.EJB_DD_ENTRY}));
            } else {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: No deployment descriptor xml file found, looking for [ {0} ]", new Object[]{DescriptorConstants.EJB_DD_ENTRY}));
            }
        }
        catch (FileNotFoundException ex) {
            Verifier.debug(ex);
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: File not found trying to read deployment descriptor file [ {0} ]", new Object[]{DescriptorConstants.EJB_DD_ENTRY}));
        }
        catch (IOException ex) {
            Verifier.debug(ex);
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: IO Error trying to read deployment descriptor file [ {0} ]", new Object[]{DescriptorConstants.EJB_DD_ENTRY}));
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
                if (deploymentEntry != null) {
                    deploymentEntry.close();
                }
            }
            catch (Exception x) {}
        }
        return result;
    }
}

