/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.connector;

import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.io.ConnectorDeploymentDescriptorFile;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.JarCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.dd.ParseDD;
import java.io.File;
import java.io.FileInputStream;
import java.net.URI;
import org.glassfish.deployment.common.Descriptor;

public class ConnectorCheckMgrImpl
extends CheckMgr
implements JarCheck {
    private static final String testsListFileName = "TestNamesConnector.xml";
    private static final String sunONETestsListFileName = ConnectorCheckMgrImpl.getSunPrefix().concat("TestNamesConnector.xml");

    public ConnectorCheckMgrImpl(VerifierFrameworkContext verifierFrameworkContext) {
        this.verifierFrameworkContext = verifierFrameworkContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(Descriptor descriptor) throws Exception {
        if (this.getSchemaVersion(descriptor).compareTo("1.5") < 0) {
            ConnectorDeploymentDescriptorFile ddf = new ConnectorDeploymentDescriptorFile();
            File file = new File(new File(URI.create(this.getAbstractArchiveUri(descriptor))), ddf.getDeploymentDescriptorPath());
            FileInputStream is = new FileInputStream(file);
            try {
                if (is != null) {
                    Result result = new ParseDD().validateConnectorDescriptor(is);
                    result.setComponentName(this.getArchiveUri(descriptor));
                    this.setModuleName(result);
                    this.verifierFrameworkContext.getResultManager().add(result);
                }
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        super.check(descriptor);
    }

    @Override
    protected String getTestsListFileName() {
        return testsListFileName;
    }

    @Override
    protected String getSunONETestsListFileName() {
        if (System.getProperty("verifier.tests.sunconnector", "false").equals("true")) {
            return sunONETestsListFileName;
        }
        return null;
    }

    @Override
    protected String getSchemaVersion(Descriptor descriptor) {
        return ((ConnectorDescriptor)descriptor).getSpecVersion();
    }

    @Override
    protected void setModuleName(Result r) {
        r.setModuleName("connector");
    }

    @Override
    protected ComponentNameConstructor getComponentNameConstructor(Descriptor descriptor) {
        return new ComponentNameConstructor((BundleDescriptor)((ConnectorDescriptor)descriptor));
    }
}

