/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.classfile;

import com.sun.enterprise.tools.verifier.apiscan.classfile.ASMClassFile;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFile;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

class ASMClassFileLoader
implements ClassFileLoader {
    private ClassLoader cl;
    private static String resourceBundleName = "com.sun.enterprise.tools.verifier.apiscan.LocalStrings";
    private static Logger logger = Logger.getLogger("apiscan.classfile", resourceBundleName);
    private static final String myClassName = "ASMClassFileLoader";
    private Map<String, WeakReference<ClassFile>> loadedClassesCache = new HashMap<String, WeakReference<ClassFile>>();

    public ASMClassFileLoader(String cp) {
        ArrayList<URL> urls = new ArrayList<URL>();
        StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            try {
                urls.add(new File(entry).toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.logp(Level.WARNING, myClassName, "init<>", this.getClass().getName() + ".exception1", new Object[]{entry});
                logger.log(Level.WARNING, "", e);
            }
        }
        this.cl = new URLClassLoader(urls.toArray(new URL[0]), null);
    }

    public ASMClassFileLoader(ClassLoader cl) {
        this.cl = cl;
    }

    @Override
    public ClassFile load(String externalClassName) throws IOException {
        logger.entering(myClassName, "load", externalClassName);
        WeakReference<ClassFile> cachedCF = this.loadedClassesCache.get(externalClassName);
        if (cachedCF != null) {
            ClassFile cf = (ClassFile)cachedCF.get();
            if (cf != null) {
                return cf;
            }
            logger.logp(Level.FINE, myClassName, "load", "{0} has been garbage collected from cache!", externalClassName);
        }
        return this.load0(externalClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassFile load0(String externalClassName) throws IOException {
        String internalClassName = externalClassName.replace('.', '/');
        InputStream is = this.cl.getResourceAsStream(internalClassName + ".class");
        if (is == null) {
            throw new IOException("Not able to load " + internalClassName + ".class");
        }
        try {
            ASMClassFile cf = new ASMClassFile(is);
            this.matchClassSignature(cf, externalClassName);
            this.loadedClassesCache.put(externalClassName, new WeakReference<ASMClassFile>(cf));
            ASMClassFile aSMClassFile = cf;
            return aSMClassFile;
        }
        finally {
            is.close();
        }
    }

    private void matchClassSignature(ClassFile cf, String externalClassName) throws IOException {
        String nameOfLoadedClass = cf.getName();
        if (!nameOfLoadedClass.equals(externalClassName)) {
            throw new IOException(externalClassName + ".class represents " + cf.getName() + ". Perhaps your package name is incorrect or you passed the " + "name using internal form instead of using external form.");
        }
    }
}

