/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.config.serverbeans.DasConfig;
import com.sun.enterprise.deploy.shared.ArchiveFactory;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.archivist.ApplicationFactory;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.util.ApplicationValidator;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.v3.common.HTMLActionReporter;
import java.io.File;
import java.io.IOException;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.OpsParams;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Service;
import org.xml.sax.SAXParseException;

@Service
public class DescriptorFactory {
    @Inject
    Deployment deployment;
    @Inject
    protected ArchiveFactory archiveFactory;
    @Inject
    ArchivistFactory archivistFactory;
    @Inject
    protected ApplicationFactory applicationFactory;
    @Inject
    DasConfig dasConfig;
    @Inject
    ServerEnvironment env;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultHolder createApplicationDescriptor(File archiveFile, File destRootDir, ClassLoader parentCl) throws IOException {
        ReadableArchive archive = null;
        Application application = null;
        try {
            Descriptor.setBoundsChecking((boolean)false);
            archive = this.archiveFactory.openArchive(archiveFile);
            ArchiveHandler archiveHandler = this.deployment.getArchiveHandler(archive);
            HTMLActionReporter dummyReport = new HTMLActionReporter();
            String appName = DeploymentUtils.getDefaultEEName((String)archiveFile.getName());
            DeployCommandParameters params = new DeployCommandParameters();
            params.name = appName;
            DeploymentContextImpl context = new DeploymentContextImpl((ActionReport)dummyReport, archive, (OpsParams)params, this.env);
            context.setArchiveHandler(archiveHandler);
            if (!archiveFile.isDirectory()) {
                File destDir = new File(destRootDir, appName);
                if (destDir.exists()) {
                    FileUtils.whack((File)destDir);
                }
                destDir.mkdirs();
                archiveHandler.expand(archive, this.archiveFactory.createArchive(destDir), (DeploymentContext)context);
                archive.close();
                archive = this.archiveFactory.openArchive(destDir);
                context.setSource(archive);
            }
            context.addTransientAppMetaData("isTempClassLoader", (Object)Boolean.TRUE);
            String archiveType = context.getArchiveHandler().getArchiveType();
            ClassLoader cl = archiveHandler.getClassLoader(parentCl, (DeploymentContext)context);
            Archivist archivist = this.archivistFactory.getArchivist(archiveType, cl);
            if (archivist == null) {
                throw new IOException("Cannot determine the Java EE module type for " + archive.getURI());
            }
            archivist.setAnnotationProcessingRequested(true);
            String xmlValidationLevel = this.dasConfig.getDeployXmlValidation();
            archivist.setXMLValidationLevel(xmlValidationLevel);
            if (xmlValidationLevel.equals("none")) {
                archivist.setXMLValidation(false);
            }
            archivist.setRuntimeXMLValidation(false);
            try {
                application = this.applicationFactory.openArchive(appName, archivist, archive, true);
            }
            catch (SAXParseException e) {
                throw new IOException(e);
            }
            if (application != null) {
                application.setClassLoader(cl);
                application.visit((ComponentVisitor)new ApplicationValidator());
            }
        }
        finally {
            if (archive != null) {
                archive.close();
            }
            Descriptor.setBoundsChecking((boolean)true);
        }
        ResultHolder result = new ResultHolder();
        result.application = application;
        result.archive = archive;
        return result;
    }

    public static class ResultHolder {
        Application application;
        Archive archive;
    }
}

