/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.loader.ASURLClassLoader;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.SpecVersionMapper;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.WebClosureCompiler;
import com.sun.enterprise.tools.verifier.web.WebCheckMgrImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Random;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.ModuleDescriptor;

public class WebVerifier
extends BaseVerifier {
    private WebBundleDescriptor webd = null;
    private String classPath;
    private boolean isASMode = false;
    private File jspOutDir = null;

    public WebVerifier(VerifierFrameworkContext verifierFrameworkContext, WebBundleDescriptor webd) {
        this.verifierFrameworkContext = verifierFrameworkContext;
        this.webd = webd;
        this.isASMode = !verifierFrameworkContext.isPortabilityMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verify() throws Exception {
        if (this.areTestsNotRequired(this.verifierFrameworkContext.isWeb()) && this.areTestsNotRequired(this.verifierFrameworkContext.isWebServices()) && this.areTestsNotRequired(this.verifierFrameworkContext.isWebServicesClient()) && this.areTestsNotRequired(this.verifierFrameworkContext.isPersistenceUnits())) {
            return;
        }
        this.jspOutDir = this.getJspOutDir();
        try {
            this.preVerification();
            this.context.setOutDir(this.jspOutDir);
            this.createClosureCompiler();
            this.verify((Descriptor)this.webd, new WebCheckMgrImpl(this.verifierFrameworkContext));
        }
        finally {
            if (this.verifierFrameworkContext.getJspOutDir() == null) {
                FileUtils.whack((File)this.jspOutDir);
            }
        }
    }

    @Override
    public Descriptor getDescriptor() {
        return this.webd;
    }

    @Override
    protected ClassLoader createClassLoader() throws IOException {
        ASURLClassLoader ASURLClassLoader2 = new ASURLClassLoader(this.webd.getClassLoader());
        ASURLClassLoader2.appendURL(this.jspOutDir);
        return ASURLClassLoader2;
    }

    @Override
    protected String getArchiveUri() {
        return FileUtils.makeFriendlyFilename((String)this.webd.getModuleDescriptor().getArchiveUri());
    }

    @Override
    protected String[] getDDString() {
        String[] dd = new String[]{"WEB-INF/sun-web.xml", "WEB-INF/web.xml", "WEB-INF/glassfish-web.xml", "WEB-INF/webservices.xml"};
        return dd;
    }

    @Override
    protected String getClassPath() throws IOException {
        String cp;
        if (this.classPath != null) {
            return this.classPath;
        }
        if (this.isASMode) {
            this.classPath = this.getClassPath(this.verifierFrameworkContext.getClassPath()) + File.pathSeparator + this.jspOutDir.getAbsolutePath();
            return this.classPath;
        }
        if (!this.webd.getModuleDescriptor().isStandalone()) {
            String ear_uri = this.verifierFrameworkContext.getExplodedArchivePath();
            File ear = new File(ear_uri);
            assert (ear.isDirectory());
            String earCP = ClassPathBuilder.buildClassPathForEar(ear);
            String libdir = this.webd.getApplication().getLibraryDirectory();
            if (libdir != null) {
                earCP = this.getLibdirClasspath(ear_uri, libdir) + earCP;
            }
            String module_uri = this.webd.getModuleDescriptor().getArchiveUri();
            File module = new File(module_uri);
            assert (module.isFile() && !module.isAbsolute());
            File explodedModuleDir = new File(ear_uri, FileUtils.makeFriendlyFilename((String)module_uri));
            String moduleCP = ClassPathBuilder.buildClassPathForWar(explodedModuleDir);
            cp = moduleCP + File.pathSeparator + earCP;
        } else {
            String module_uri = this.verifierFrameworkContext.getExplodedArchivePath();
            File module = new File(module_uri);
            assert (module.isDirectory() && module.isAbsolute());
            cp = ClassPathBuilder.buildClassPathForWar(module);
        }
        String as_lib_root = System.getProperty("com.sun.aas.installRoot") + File.separator + "lib" + File.separator;
        if (this.verifierFrameworkContext.getJavaEEVersion().compareTo("5") >= 0) {
            cp = cp + File.pathSeparator + as_lib_root + "javax.faces.jar" + File.pathSeparator + as_lib_root + "appserv-jstl.jar" + File.pathSeparator;
        }
        this.classPath = cp = cp + File.pathSeparator + this.jspOutDir.getAbsolutePath();
        return this.classPath;
    }

    protected void createClosureCompiler() throws IOException {
        String specVer = SpecVersionMapper.getWebAppVersion(this.verifierFrameworkContext.getJavaEEVersion());
        Object arg = this.isASMode ? this.context.getClassLoader() : this.getClassPath();
        WebClosureCompiler cc = new WebClosureCompiler(specVer, ClassFileLoaderFactory.newInstance(new Object[]{arg}));
        this.context.setClosureCompiler(cc);
    }

    private File getJspOutDir() {
        float f;
        String outDirPath;
        File out;
        File jspOutDir = this.verifierFrameworkContext.getJspOutDir();
        if (jspOutDir != null) {
            ModuleDescriptor moduleDescriptor = this.webd.getModuleDescriptor();
            if (moduleDescriptor.isStandalone()) {
                return jspOutDir;
            }
            return new File(jspOutDir, FileUtils.makeFriendlyFilename((String)moduleDescriptor.getArchiveUri()));
        }
        Random random = new Random();
        String prefix = System.getProperty("java.io.tmpdir") + File.separator + ".jspc";
        do {
            f = random.nextFloat();
        } while (!(out = new File(outDirPath = new String(prefix + f))).mkdirs());
        return out;
    }
}

