/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.persistence;

import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import org.glassfish.deployment.common.Descriptor;

public class ClassNotFound
extends VerifierTest
implements VerifierCheck {
    @Override
    public Result check(Descriptor descriptor) {
        Result result = this.getInitializedResult();
        this.addErrorDetails(result, this.getVerifierContext().getComponentNameConstructor());
        result.setStatus(0);
        PersistenceUnitDescriptor pu = (PersistenceUnitDescriptor)PersistenceUnitDescriptor.class.cast(descriptor);
        for (String className : pu.getClasses()) {
            try {
                Class.forName(className, false, this.getVerifierContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                result.failed(smh.getLocalString(this.getClass().getName() + "failed1", "Class [ {0} ] could not be loaded", new Object[]{className}));
            }
            catch (NoClassDefFoundError e) {
                result.failed(smh.getLocalString(this.getClass().getName() + "failed2", "Class [ {0} ] could not be loaded because a dependent class could not be loaded. See reason:\n [ {1} ]", new Object[]{className, e.getMessage()}));
            }
        }
        return result;
    }
}

