/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.ResultManager;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.util.LogDomains;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReportHandler {
    private final String TEST = "test";
    private final String TEST_NAME = "test-name";
    private final String TEST_DESC = "test-description";
    private final String TEST_ASSERTION = "test-assertion";
    private final String STATIC_VER = "static-verification";
    private final String FAILED = "failed";
    private final String PASSED = "passed";
    private final String NOTAPPLICABLE = "not-applicable";
    private final String WARNING = "warning";
    private final String FAILNUMBER = "failure-number";
    private final String WARNINGNUMBER = "warning-number";
    private final String ERRORNUMBER = "error-number";
    private final String FAILCOUNT = "failure-count";
    private final String ERROR = "error";
    private final String ERROR_NAME = "error-name";
    private final String ERROR_DESC = "error-description";
    private final String XSL_FILE = "textFormatForVerifierSS";
    private String outputFileStr = null;
    private Element rootNode = null;
    private Document document;
    private String textResult;
    private ResultManager resultMgr;
    private VerifierFrameworkContext verifierFrameworkContext;
    private Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");

    public ReportHandler(VerifierFrameworkContext verifierFrameworkContext) {
        this.verifierFrameworkContext = verifierFrameworkContext;
        this.resultMgr = verifierFrameworkContext.getResultManager();
        String onlyJarFile = new File(verifierFrameworkContext.getJarFileName()).getName();
        String outputDirName = this.formatOutputDirName(verifierFrameworkContext.getOutputDirName());
        String string = outputDirName = outputDirName == null ? "" : outputDirName + File.separator;
        if (verifierFrameworkContext.isUseTimeStamp()) {
            SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddhhmmss");
            this.outputFileStr = outputDirName + onlyJarFile + dateFormatter.format(new Date());
        } else {
            this.outputFileStr = outputDirName + onlyJarFile;
        }
    }

    public void generateAllReports() throws IOException {
        this.createResultsDocument(this.verifierFrameworkContext.getReportLevel());
        this.writeToXmlFile();
        this.writeToTxtFile();
        this.writeToConsole();
    }

    private void writeToConsole() {
        if (this.verifierFrameworkContext.isUsingGui()) {
            return;
        }
        if (this.verifierFrameworkContext.isBackend()) {
            this.logger.log(Level.SEVERE, this.textResult);
        } else {
            this.logger.log(Level.INFO, this.getClass().getName() + ".resultSummary", new Object[]{new Integer(this.resultMgr.getFailedCount()), new Integer(this.resultMgr.getWarningCount()), new Integer(this.resultMgr.getErrorCount())});
        }
        if (this.resultMgr.getFailedCount() + this.resultMgr.getWarningCount() + this.resultMgr.getErrorCount() != 0 || this.verifierFrameworkContext.getReportLevel() == 2) {
            this.logger.log(Level.INFO, this.getClass().getName() + ".LookInResultsTestAssertions", new Object[]{this.outputFileStr + ".txt"});
        } else {
            this.logger.log(Level.INFO, this.getClass().getName() + ".LookInResultsTestAssertions1");
        }
    }

    private void createResultsDocument(int reportLevel) throws IOException {
        this.createDOMTree();
        if (reportLevel != 0) {
            this.addResultsToDocument("warning", this.resultMgr.getWarningResults());
        }
        if (reportLevel == 2) {
            this.addResultsToDocument("passed", this.resultMgr.getOkayResults());
            this.addResultsToDocument("not-applicable", this.resultMgr.getNaResults());
        }
        this.addResultsToDocument("failed", this.resultMgr.getFailedResults());
        Vector error = this.resultMgr.getError();
        if (!error.isEmpty()) {
            for (int i = 0; i < error.size(); ++i) {
                LogRecord lr = (LogRecord)error.get(i);
                this.generateErrors(lr);
            }
        }
        this.failureCount();
    }

    private void createDOMTree() throws IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        this.document = builder.newDocument();
        this.rootNode = this.document.createElement("static-verification");
        this.document.appendChild(this.rootNode);
    }

    private void addResultsToDocument(String status, Vector resultVector) {
        for (int i = 0; i < resultVector.size(); ++i) {
            Result r = (Result)resultVector.get(i);
            String moduleName = r.getModuleName();
            Enumeration en = status == "failed" ? r.getErrorDetails().elements() : (status == "warning" ? r.getWarningDetails().elements() : (status == "passed" ? r.getGoodDetails().elements() : r.getNaDetails().elements()));
            this.createNode(moduleName, status);
            this.addToDocument(moduleName, status, r, en);
        }
    }

    private void generateErrors(LogRecord record) {
        Element errorNode = null;
        NodeList nodeList = this.document.getElementsByTagName("error");
        if (nodeList.getLength() == 0) {
            errorNode = this.document.createElement("error");
            this.rootNode.appendChild(errorNode);
        } else {
            errorNode = (Element)nodeList.item(0);
        }
        Element excepName = this.getTextNode("error-name", record.getMessage());
        errorNode.appendChild(excepName);
        if (record.getThrown() != null) {
            Element excepDescr = this.getTextNode("error-description", this.writeStackTraceToFile(record.getThrown()));
            errorNode.appendChild(excepDescr);
        }
    }

    private void createNode(String moduleName, String status) {
        Element moduleNode;
        NodeList nodeList = this.document.getElementsByTagName(moduleName);
        if (nodeList.getLength() == 0) {
            moduleNode = this.document.createElement(moduleName);
            this.rootNode.appendChild(moduleNode);
        } else {
            moduleNode = (Element)nodeList.item(0);
        }
        nodeList = moduleNode.getChildNodes();
        Element statusNode = null;
        if (nodeList.getLength() == 0) {
            statusNode = this.document.createElement(status);
            moduleNode.appendChild(statusNode);
        } else {
            for (int j = 0; j < nodeList.getLength(); ++j) {
                if (!((Element)nodeList.item(j)).getTagName().equals(status)) continue;
                statusNode = (Element)nodeList.item(j);
                break;
            }
            if (statusNode == null) {
                statusNode = this.document.createElement(status);
                moduleNode.appendChild(statusNode);
            }
        }
    }

    private void addToDocument(String moduleName, String status, Result r, Enumeration en) {
        if (r == null) {
            return;
        }
        NodeList nodeList = this.document.getElementsByTagName(moduleName).item(0).getChildNodes();
        Element statusNode = null;
        for (int j = 0; j < nodeList.getLength(); ++j) {
            if (!((Element)nodeList.item(j)).getTagName().equals(status)) continue;
            statusNode = (Element)nodeList.item(j);
            break;
        }
        Element test = this.document.createElement("test");
        Element testName = this.getTextNode("test-name", r.getTestName());
        Element testAssertion = this.getTextNode("test-assertion", r.getAssertion());
        String string = "";
        while (en.hasMoreElements()) {
            string = string + (String)en.nextElement() + "\n";
        }
        Element testDescr = this.getTextNode("test-description", string);
        test.appendChild(testName);
        test.appendChild(testAssertion);
        test.appendChild(testDescr);
        statusNode.appendChild(test);
    }

    private Element getTextNode(String tag, String text) {
        Element element = this.document.createElement(tag);
        element.appendChild(this.document.createTextNode(text));
        return element;
    }

    private void writeToXmlFile() throws IOException {
        FileOutputStream fos = null;
        try {
            File outputFile = this.extractResultsFileToTmpDir(this.outputFileStr + ".xml");
            DOMSource domSource = new DOMSource(this.document);
            TransformerFactory tfactory = TransformerFactory.newInstance();
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            String encoding = System.getProperty("file.encoding");
            transformer.setOutputProperty("encoding", encoding);
            fos = new FileOutputStream(outputFile);
            transformer.transform(domSource, new StreamResult(fos));
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void writeToTxtFile() throws IOException {
        InputStream xslFile = this.getLocalizedXSLFile();
        Document dynamicDocument = this.document;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.generateText(dynamicDocument, xslFile, output);
        this.textResult = output.toString("UTF-8");
        File outputFile = this.extractResultsFileToTmpDir(this.outputFileStr + ".txt");
        OutputStreamWriter fw = new OutputStreamWriter(new FileOutputStream(outputFile));
        fw.write(this.textResult);
        fw.close();
    }

    private File extractResultsFileToTmpDir(String jarFile) {
        File tmpJarFile = null;
        tmpJarFile = new File(jarFile);
        String fullFilename = tmpJarFile.getAbsolutePath();
        if (new File(fullFilename).getParent() != null) {
            new File(new File(fullFilename).getParent()).mkdirs();
        }
        return tmpJarFile;
    }

    private void generateText(Document xmlResult, InputStream stylesheet, OutputStream output) throws IOException {
        FileOutputStream fos = null;
        try {
            Transformer transformer;
            TransformerFactory tFactory = TransformerFactory.newInstance();
            if (stylesheet != null) {
                StreamSource styleSource = new StreamSource(stylesheet);
                transformer = tFactory.newTransformer(styleSource);
            } else {
                transformer = tFactory.newTransformer();
            }
            DOMSource source = new DOMSource(xmlResult);
            StreamResult streamResult = new StreamResult(output);
            transformer.transform(source, streamResult);
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private void failureCount() {
        int failedCount = this.resultMgr.getFailedCount();
        int warningCount = this.resultMgr.getWarningCount();
        int errorCount = this.resultMgr.getErrorCount();
        Element failureNode = null;
        NodeList nodeList = this.document.getElementsByTagName("failure-count");
        if (nodeList.getLength() == 0) {
            failureNode = this.document.createElement("failure-count");
            this.rootNode.appendChild(failureNode);
        } else {
            failureNode = (Element)nodeList.item(0);
        }
        nodeList = failureNode.getChildNodes();
        Element failed_count = null;
        Element warning_count = null;
        Element error_count = null;
        if (nodeList.getLength() == 0) {
            failed_count = this.getTextNode("failure-number", new Integer(failedCount).toString());
            failureNode.appendChild(failed_count);
            warning_count = this.getTextNode("warning-number", new Integer(warningCount).toString());
            failureNode.appendChild(warning_count);
            error_count = this.getTextNode("error-number", new Integer(errorCount).toString());
            failureNode.appendChild(error_count);
        } else {
            for (int j = 0; j < nodeList.getLength(); ++j) {
                if (((Element)nodeList.item(j)).getTagName().equals("failure-number")) {
                    failed_count = (Element)nodeList.item(j);
                    failed_count.getFirstChild().setNodeValue(new Integer(failedCount).toString());
                }
                if (((Element)nodeList.item(j)).getTagName().equals("warning-number")) {
                    warning_count = (Element)nodeList.item(j);
                    warning_count.getFirstChild().setNodeValue(new Integer(warningCount).toString());
                }
                if (!((Element)nodeList.item(j)).getTagName().equals("error-number")) continue;
                error_count = (Element)nodeList.item(j);
                error_count.getFirstChild().setNodeValue(new Integer(errorCount).toString());
            }
            if (failed_count == null) {
                failed_count = this.getTextNode("failure-number", new Integer(failedCount).toString());
                failureNode.appendChild(failed_count);
            }
            if (warning_count == null) {
                warning_count = this.getTextNode("warning-number", new Integer(warningCount).toString());
                failureNode.appendChild(warning_count);
            }
            if (error_count == null) {
                error_count = this.getTextNode("error-number", new Integer(errorCount).toString());
                failureNode.appendChild(error_count);
            }
        }
    }

    private String writeStackTraceToFile(Throwable e) {
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        return sw.toString();
    }

    private InputStream getLocalizedXSLFile() {
        Locale locale = Locale.getDefault();
        String xslFileName = "com/sun/enterprise/tools/verifier/config/textFormatForVerifierSS_" + locale.toString() + ".xsl";
        ClassLoader loader = this.getClass().getClassLoader();
        InputStream is = loader.getResourceAsStream(xslFileName);
        if (is != null) {
            return is;
        }
        xslFileName = "com/sun/enterprise/tools/verifier/config/textFormatForVerifierSS_" + locale.getLanguage() + ".xsl";
        is = loader.getResourceAsStream(xslFileName);
        if (is != null) {
            return is;
        }
        xslFileName = "com/sun/enterprise/tools/verifier/config/textFormatForVerifierSS.xsl";
        is = loader.getResourceAsStream(xslFileName);
        return is;
    }

    private String formatOutputDirName(String outputDirName) {
        if (outputDirName != null && outputDirName.trim().length() > 0) {
            char[] outputDirNameArr = outputDirName.toCharArray();
            StringBuffer formName = new StringBuffer();
            for (int i = 0; i < outputDirNameArr.length; ++i) {
                if (outputDirNameArr[i] == '/' || outputDirNameArr[i] == '\\') {
                    formName.append(File.separatorChar);
                    continue;
                }
                formName.append(outputDirNameArr[i]);
            }
            return formName.toString();
        }
        return outputDirName;
    }
}

