/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.wsclients;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.ServiceRefPortInfo;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientCheck;
import com.sun.enterprise.tools.verifier.tests.wsclients.WSClientTest;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class PortComponentLinkValidCheck
extends WSClientTest
implements WSClientCheck {
    ComponentNameConstructor compName;

    @Override
    public Result check(ServiceReferenceDescriptor descriptor) {
        Result result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        boolean pass = true;
        Set ports = descriptor.getPortsInfo();
        for (ServiceRefPortInfo ref : ports) {
            if (!ref.hasPortComponentLinkName()) {
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notapp", "Not applicable since port-comp-link does not exist in port-comp-ref [{0}].", new Object[]{ref.getName()}));
                continue;
            }
            if (ref.getPortComponentLink() != null) {
                pass = true;
                continue;
            }
            if (this.isLinkValid(ref)) continue;
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Invalid port-component-link [{0}] in WebService client [{1}].", new Object[]{ref.getPortComponentLinkName(), this.compName.toString()}));
            pass = false;
        }
        if (pass) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "All port-component-link(s) in this service reference are valid."));
        }
        return result;
    }

    private boolean isLinkValid(ServiceRefPortInfo ref) {
        boolean pass = true;
        WebServiceEndpoint port = null;
        String linkName = ref.getPortComponentLinkName();
        Application application = ref.getServiceReference().getBundleDescriptor().getApplication();
        if (linkName != null && linkName.length() > 0 && application != null) {
            int hashIndex = linkName.indexOf(35);
            String relativeModuleUri = linkName.substring(0, hashIndex);
            String portName = linkName.substring(hashIndex + 1);
            Set webBundles = application.getBundleDescriptors(WebBundleDescriptor.class);
            Set ejbBundles = application.getBundleDescriptors(EjbBundleDescriptor.class);
            Iterator ejbBundlesIterator = ejbBundles.iterator();
            EjbBundleDescriptor ejbBundle = null;
            while (ejbBundlesIterator.hasNext()) {
                ejbBundle = (EjbBundleDescriptor)ejbBundlesIterator.next();
                try {
                    String archiveuri = ejbBundle.getModuleDescriptor().getArchiveUri();
                    if (!relativeModuleUri.equals(archiveuri)) continue;
                    LinkedList<EjbBundleDescriptor> bundles = new LinkedList<EjbBundleDescriptor>();
                    bundles.addFirst(ejbBundle);
                    for (BundleDescriptor bundleDescriptor : bundles) {
                        port = bundleDescriptor.getWebServiceEndpointByName(portName);
                        if (port == null) continue;
                        pass = true;
                    }
                }
                catch (Exception e) {}
            }
            Iterator webBundlesIterator = webBundles.iterator();
            WebBundleDescriptor webBundle = null;
            while (webBundlesIterator.hasNext()) {
                webBundle = (WebBundleDescriptor)webBundlesIterator.next();
                try {
                    String archiveuri = webBundle.getModuleDescriptor().getArchiveUri();
                    if (!relativeModuleUri.equals(archiveuri)) continue;
                    LinkedList<WebBundleDescriptor> linkedList = new LinkedList<WebBundleDescriptor>();
                    linkedList.addFirst(webBundle);
                    for (BundleDescriptor bundleDescriptor : linkedList) {
                        port = bundleDescriptor.getWebServiceEndpointByName(portName);
                        if (port == null) continue;
                        pass = true;
                    }
                }
                catch (Exception e) {}
            }
        }
        if (port == null) {
            pass = false;
        }
        return pass;
    }
}

