/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;

public class TagLibPublicID
extends WebTest
implements WebCheck {
    @Override
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        String[] acceptablePubidLiterals = new String[]{"-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN", "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN"};
        String[] acceptableURLs = new String[]{"http://java.sun.com/j2ee/dtds/web-jsptaglibrary_1_1.dtd", "http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd"};
        VerifierTestContext context = this.getVerifierContext();
        TagLibDescriptor[] tlds = context.getTagLibDescriptors();
        this.addGoodDetails(result, compName);
        result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Test passed successfully"));
        if (tlds != null && tlds.length != 0) {
            boolean oneFailed = false;
            for (int i = 0; i < tlds.length; ++i) {
                String publicID = tlds[i].getPublicID();
                String systemID = tlds[i].getSystemID();
                if (publicID == null) continue;
                boolean match = false;
                for (int k = 0; k < acceptablePubidLiterals.length; ++k) {
                    if (publicID.compareTo(acceptablePubidLiterals[k]) != 0 || systemID.compareTo(acceptableURLs[k]) != 0) continue;
                    match = true;
                    this.addGoodDetails(result, compName);
                    result.passed(smh.getLocalString(this.getClass().getName() + ".passed1", "The deployment descriptor [ {0} ] has the proper PubidLiteral: [ {1} ] and sytemID: [ {2} ]", new Object[]{tlds[i].getUri(), acceptablePubidLiterals[k], acceptableURLs[k]}));
                    break;
                }
                if (match) continue;
                oneFailed = true;
                this.addErrorDetails(result, compName);
                result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "The deployment descriptor for [ {0} ] does not have an expected PubidLiteral or SystemID", new Object[]{tlds[i].getUri()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            }
            return result;
        }
        return result;
    }
}

