/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.web.FilterClass;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.logging.Level;

public class FilterClassHasValidConstructor
extends FilterClass
implements WebCheck {
    @Override
    protected boolean runIndividualFilterTest(Result result, Class filterClass) {
        boolean validConstructor = false;
        boolean foundIt = false;
        Class clazz = filterClass;
        if (filterClass == null) {
            return false;
        }
        do {
            Constructor<?>[] constructors = filterClass.getDeclaredConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                this.logger.log(Level.FINE, this.getClass().getName() + ".debug", new Object[]{constructors[i].toString()});
                Class<?>[] parameters = constructors[i].getParameterTypes();
                if (parameters.length != 0) continue;
                validConstructor = Modifier.isPublic(constructors[i].getModifiers());
                foundIt = true;
            }
        } while (!foundIt && (filterClass = filterClass.getSuperclass()) != null);
        if (validConstructor) {
            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Listener class [ {0} ] implements a valid constructor.", new Object[]{filterClass.getName()}));
        } else {
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Listener class [ {0} ] does not implement a valid constructor.", new Object[]{clazz.getName()}));
        }
        return validConstructor;
    }
}

