/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf;

import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;
import org.glassfish.ejb.deployment.descriptor.EjbEntityDescriptor;

public abstract class InterfaceMethodTest
extends EjbTest {
    static String[] EJBObjectMethods = new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical", "remove", "getEJBLocalHome"};

    protected abstract String getInterfaceName(EjbDescriptor var1);

    protected abstract String getInterfaceType();

    protected abstract boolean runIndividualMethodTest(EjbDescriptor var1, Method var2, Result var3);

    @Override
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return result;
        }
        if (this.getInterfaceName(descriptor) == null || "".equals(this.getInterfaceName(descriptor))) {
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.intf.InterfaceTest.notApplicable", "Not Applicable because, EJB [ {0} ] does not have {1} Interface.", new Object[]{descriptor.getEjbClassName(), this.getInterfaceType()}));
            return result;
        }
        try {
            Arrays.sort(EJBObjectMethods);
            ClassLoader jcl = this.getVerifierContext().getClassLoader();
            Class<?> interfaceClass = Class.forName(this.getClassName(descriptor), false, jcl);
            if (this.studyInterface(descriptor, interfaceClass, result)) {
                result.setStatus(0);
            } else {
                result.setStatus(1);
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: " + this.getInterfaceType() + "interface [ {0} ] does not " + "exist or is not loadable within bean [ {1} ]", new Object[]{this.getClassName(descriptor), descriptor.getName()}));
        }
        return result;
    }

    private boolean studyInterface(EjbDescriptor descriptor, Class clazz, Result result) {
        boolean allGood = true;
        Method[] interfaceMethods = clazz.getDeclaredMethods();
        for (Method method : interfaceMethods) {
            if (Arrays.binarySearch(EJBObjectMethods, method.getName()) >= 0 || this.runIndividualMethodTest(descriptor, method, result)) continue;
            allGood = false;
        }
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            if (this.studyInterface(descriptor, (Class)genericDeclaration, result)) continue;
            allGood = false;
        }
        return allGood;
    }

    private String getClassName(EjbDescriptor descriptor) {
        return this.getInterfaceName(descriptor);
    }
}

