/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.Set;
import org.glassfish.ejb.deployment.descriptor.EjbDescriptor;

public class CallbacksOnBeanClass
extends EjbTest {
    Result result = null;
    ComponentNameConstructor compName = null;

    @Override
    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        Set interceptors = descriptor.getInterceptorClasses();
        for (EjbInterceptor interceptor : interceptors) {
            Set callBackDescs;
            if (interceptor.hasCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE)) {
                callBackDescs = interceptor.getCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType.POST_ACTIVATE);
                this.reportError(callBackDescs, "ejbActivate", interceptor.getInterceptorClassName());
            }
            if (interceptor.hasCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE)) {
                callBackDescs = interceptor.getCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType.PRE_PASSIVATE);
                this.reportError(callBackDescs, "ejbPassivate", interceptor.getInterceptorClassName());
            }
            if (interceptor.hasCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT)) {
                callBackDescs = interceptor.getCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT);
                this.reportError(callBackDescs, "ejbCreate", interceptor.getInterceptorClassName());
            }
            if (!interceptor.hasCallbackDescriptor(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY)) continue;
            callBackDescs = interceptor.getCallbackDescriptors(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY);
            this.reportError(callBackDescs, "ejbRemove", interceptor.getInterceptorClassName());
        }
        if (this.result.getStatus() != 1) {
            this.addGoodDetails(this.result, this.compName);
            this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Valid lifecycle callback method(s)"));
        }
        return this.result;
    }

    private void reportError(Set<LifecycleCallbackDescriptor> callBackDescs, String callbackMethodName, String interceptorClassName) {
        for (LifecycleCallbackDescriptor callbackDesc : callBackDescs) {
            String callbackMethod = callbackDesc.getLifecycleCallbackMethod();
            if (!callbackMethod.contains(callbackMethodName)) continue;
            this.result.getFaultLocation().setFaultyClassName(interceptorClassName);
            this.result.getFaultLocation().setFaultyMethodName(callbackMethod);
            this.addErrorDetails(this.result, this.compName);
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Wrong method [ {0} ] in class [ {1} ]", new Object[]{callbackMethod, interceptorClassName}));
        }
    }
}

