/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.deployment.WebServiceHandler;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.webservices.WSCheck;
import com.sun.enterprise.tools.verifier.tests.webservices.WSTest;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class HandlerPortNameCheck
extends WSTest
implements WSCheck {
    public Result check(WebServiceEndpoint descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        boolean pass = true;
        if (descriptor.hasHandlers()) {
            Collection allPortNames = this.getAllPortNamesInService(descriptor);
            LinkedList handlerChain = descriptor.getHandlerChain();
            Iterator it = handlerChain.iterator();
            while (it.hasNext()) {
                Collection c = ((WebServiceHandler)it.next()).getPortNames();
                Collection invalid = this.getInvalidHandlerPortNames(c, allPortNames);
                if (invalid.size() > 0) {
                    result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                    result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.failed", "[{0}]", new Object[]{"The Port Name(s) in the Handler Chain are invalid"}));
                    pass = false;
                    continue;
                }
                result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.passed", "[{0}]", new Object[]{"Port Name(s) in the Handler-Chain are valid"}));
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.webservices.notapp", "[{0}]", new Object[]{"Not Applicable since No handlers defined in this WebService"}));
        }
        return result;
    }

    private Collection getAllPortNamesInService(WebServiceEndpoint descriptor) {
        Collection endPoints = descriptor.getWebService().getEndpoints();
        Vector<String> ret = new Vector<String>();
        Iterator it = endPoints.iterator();
        while (it.hasNext()) {
            ret.add(((WebServiceEndpoint)it.next()).getEndpointName());
        }
        return ret;
    }

    private Collection getInvalidHandlerPortNames(Collection hpNames, Collection allPortNames) {
        Vector<String> ret = new Vector<String>();
        for (String currName : hpNames) {
            if (allPortNames.contains(currName)) continue;
            ret.add(currName);
        }
        return ret;
    }
}

