/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.io.File;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.Pattern;

public class WelcomeFile
extends WebTest
implements WebCheck {
    private Set dynamicResourceUrlPatterns = new HashSet();

    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!this.isApplicable(descriptor, result)) {
            return result;
        }
        boolean syntaxOK = this.checkSyntax(descriptor, result);
        boolean exists = true;
        if (!syntaxOK) {
            result.setStatus(1);
        } else if (!exists) {
            result.setStatus(2);
        } else {
            result.setStatus(0);
        }
        return result;
    }

    private boolean isApplicable(WebBundleDescriptor descriptor, Result result) {
        boolean applicable = true;
        if (!descriptor.getWelcomeFiles().hasMoreElements()) {
            ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
            this.addNaDetails(result, compName);
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no welcome files within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
            applicable = false;
        }
        return applicable;
    }

    private boolean checkSyntax(WebBundleDescriptor descriptor, Result result) {
        boolean syntaxOK = true;
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        Enumeration e = descriptor.getWelcomeFiles();
        while (e.hasMoreElements()) {
            String welcomefile = (String)e.nextElement();
            if (!welcomefile.startsWith("/") && !welcomefile.endsWith("/")) continue;
            this.addErrorDetails(result, compName);
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed1", "Error : Servlet 2.3 Spec 9.9 Welcome file URL [ {0} ] must be partial URLs with no trailing or leading /", new Object[]{welcomefile, descriptor.getName()}));
            syntaxOK = false;
        }
        return syntaxOK;
    }

    private boolean checkExists(WebBundleDescriptor descriptor, Result result) {
        this.findDynamicResourceURIs(descriptor);
        boolean exists = false;
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        Enumeration e = descriptor.getWelcomeFiles();
        while (e.hasMoreElements()) {
            String welcomeFile = (String)e.nextElement();
            if (this.fileExists(descriptor, welcomeFile) || this.urlMatches(welcomeFile)) {
                exists = true;
                this.addGoodDetails(result, compName);
                result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "Welcome file [ {0} ] contains the file name to use as a default welcome file within web application [ {1} ]", new Object[]{welcomeFile, descriptor.getName()}));
                continue;
            }
            this.addWarningDetails(result, compName);
            result.addWarningDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: Welcome file [ {0} ] is not found within [ {1} ] or does not contain the file name to use as a default welcome file within web application [ {2} ]", new Object[]{welcomeFile, descriptor.getModuleDescriptor().getArchiveUri(), descriptor.getName()}));
        }
        return exists;
    }

    private boolean fileExists(WebBundleDescriptor descriptor, String fileName) {
        File webCompRoot = new File(this.getAbstractArchiveUri(descriptor));
        File welcomeFile = new File(webCompRoot, fileName);
        return welcomeFile.exists();
    }

    private void findDynamicResourceURIs(WebBundleDescriptor descriptor) {
        Set webComponentDescriptors = descriptor.getWebComponentDescriptors();
        for (WebComponentDescriptor webComponentDescriptor : webComponentDescriptors) {
            this.dynamicResourceUrlPatterns.addAll(webComponentDescriptor.getUrlPatternsSet());
        }
        HashSet<String> newUrlPatterns = new HashSet<String>();
        for (String urlPattern : this.dynamicResourceUrlPatterns) {
            if (urlPattern.startsWith("/")) {
                urlPattern = urlPattern.substring(1);
            }
            if (urlPattern.endsWith("/")) {
                urlPattern = urlPattern.substring(0, urlPattern.length() - 1);
            }
            newUrlPatterns.add(urlPattern);
        }
        this.dynamicResourceUrlPatterns = newUrlPatterns;
    }

    private boolean urlMatches(String url) {
        Iterator iter = this.dynamicResourceUrlPatterns.iterator();
        while (iter.hasNext()) {
            boolean matches = Pattern.matches((String)iter.next(), url);
            if (!matches) continue;
            return true;
        }
        return false;
    }
}

