/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.SecurityConstraintImpl;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.web.WebResourceCollection;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.Enumeration;

public class WebResourceName
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor.getSecurityConstraints().hasMoreElements()) {
            boolean oneFailed = false;
            int na = 0;
            int noSc = 0;
            boolean foundIt = false;
            Enumeration e = descriptor.getSecurityConstraints();
            while (e.hasMoreElements()) {
                foundIt = false;
                ++noSc;
                SecurityConstraintImpl securityConstraintImpl = (SecurityConstraintImpl)e.nextElement();
                if (!securityConstraintImpl.getWebResourceCollections().isEmpty()) {
                    for (WebResourceCollection webResCollection : securityConstraintImpl.getWebResourceCollections()) {
                        String webRCName = webResCollection.getName();
                        foundIt = webRCName.length() > 0;
                        if (foundIt) {
                            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                            result.addGoodDetails(smh.getLocalString(this.getClass().getName() + ".passed", "web-resource-name [ {0} ] contains the name of this web resource collection within web application [ {1} ]", new Object[]{webRCName, descriptor.getName()}));
                            continue;
                        }
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                        result.addErrorDetails(smh.getLocalString(this.getClass().getName() + ".failed", "Error: web-resource-name [ {0} ] does not contain the name of this web resource collection within web application [ {1} ]", new Object[]{webRCName, descriptor.getName()}));
                    }
                    continue;
                }
                result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "There are no web web resource collections in the web security constraint within [ {0} ]", new Object[]{descriptor.getName()}));
                ++na;
            }
            if (oneFailed) {
                result.setStatus(1);
            } else if (na == noSc) {
                result.setStatus(3);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no web-resource-name elements within the web archive [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

