/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.persistence;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.PersistenceUnitsDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuplicatePUNameTest
extends VerifierTest
implements VerifierCheck {
    @Override
    public Result check(Descriptor descriptor) {
        PersistenceUnitDescriptor pu = (PersistenceUnitDescriptor)PersistenceUnitDescriptor.class.cast(descriptor);
        Result result = this.getInitializedResult();
        this.addErrorDetails(result, this.getVerifierContext().getComponentNameConstructor());
        result.setStatus(0);
        int count = 0;
        for (PersistenceUnitDescriptor nextPU : this.getPUsInSameScope(pu)) {
            result.addErrorDetails(smh.getLocalString(this.getClass().getName() + "puName", "Found a persistence unit by name [ {0} ] in persistence unit root [ {1} ]", new Object[]{nextPU.getName(), nextPU.getPuRoot()}));
            if (!nextPU.getName().equals(pu.getName())) continue;
            ++count;
        }
        if (count != 1) {
            result.failed(smh.getLocalString(this.getClass().getName() + "failed", "There are [ {0} ] number of persistence units by name [ {1} ]", new Object[]{count, pu.getName()}));
        }
        return result;
    }

    private List<PersistenceUnitDescriptor> getPUsInSameScope(PersistenceUnitDescriptor pu) {
        ArrayList<PersistenceUnitDescriptor> result;
        if (pu.getParent().getParent().isApplication()) {
            result = pu.getParent().getPersistenceUnitDescriptors();
        } else {
            result = new ArrayList<PersistenceUnitDescriptor>();
            for (PersistenceUnitsDescriptor pus : pu.getParent().getParent().getExtensionsDescriptors(PersistenceUnitsDescriptor.class)) {
                for (PersistenceUnitDescriptor nextPU : pus.getPersistenceUnitDescriptors()) {
                    result.add(nextPU);
                }
            }
        }
        return result;
    }
}

