/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.primarykeyclass;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.VerifierTestContext;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;

public class PrimaryKeyClassOpt
extends EjbTest
implements EjbCheck {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if ("Container".equals(persistence)) {
                String primkey = ((EjbEntityDescriptor)descriptor).getPrimaryKeyClassName();
                if (primkey.equals("java.lang.Object")) {
                    if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                        oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor);
                    }
                    if (!oneFailed && descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                        oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor);
                    }
                } else {
                    this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable1", "Primary Key Class is [ {0} ]", new Object[]{primkey}));
                }
                return this.result;
            }
            if ("Bean".equals(persistence)) {
                this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Entity Bean with [ {0} ] managed persistence, primkey mandatory.", new Object[]{persistence}));
                return this.result;
            }
            this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable3", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{"Container", descriptor.getName(), persistence}));
            return this.result;
        }
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
        this.result.notApplicable(smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            VerifierTestContext context = this.getVerifierContext();
            ClassLoader jcl = context.getClassLoader();
            Class<?> c = Class.forName(home, false, this.getVerifierContext().getClassLoader());
            Method[] ejbFinderMethods = c.getDeclaredMethods();
            boolean paramValid = false;
            block2: for (int j = 0; j < ejbFinderMethods.length; ++j) {
                if (!ejbFinderMethods[j].getName().equals("findByPrimaryKey")) continue;
                Class<?>[] ejbFinderMethodParameterTypes = ejbFinderMethods[j].getParameterTypes();
                for (int k = 0; k < ejbFinderMethodParameterTypes.length; ++k) {
                    if (!ejbFinderMethodParameterTypes[k].getName().equals("java.lang.Object")) continue;
                    paramValid = true;
                    continue block2;
                }
            }
            if (paramValid) {
                this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "findByPrimaryKey method properly defines method parameter [ {0} ]", new Object[]{"java.lang.Object"}));
            } else {
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: findByPrimaryKey method does not properly define method parameter [ {0} ]", new Object[]{"java.lang.Object"}));
            }
            return oneFailed;
        }
        catch (Exception e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Loading Home interface class [ {0} ]", new Object[]{home}));
            return oneFailed;
        }
    }
}

