/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2;

import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.PersistentFieldInfo;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest;
import java.lang.reflect.Method;

public class CmpFieldsAccessorExposition
extends CMPTest {
    Result result = null;
    ComponentNameConstructor compName = null;

    public Result check(EjbCMPEntityDescriptor descriptor) {
        this.result = this.getInitializedResult();
        boolean oneFailed = false;
        this.compName = this.getVerifierContext().getComponentNameConstructor();
        if (descriptor.getRemoteClassName() != null && !descriptor.getRemoteClassName().equals("")) {
            oneFailed = this.commonToBothInterfaces(descriptor.getRemoteClassName(), (EjbDescriptor)descriptor);
        }
        if (!oneFailed && descriptor.getLocalClassName() != null && !descriptor.getLocalClassName().equals("")) {
            oneFailed = this.commonToBothInterfaces(descriptor.getLocalClassName(), (EjbDescriptor)descriptor);
        }
        if (oneFailed) {
            this.result.setStatus(2);
        } else {
            this.result.setStatus(0);
        }
        return this.result;
    }

    private boolean commonToBothInterfaces(String remote, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Class<?> c = Class.forName(remote, false, this.getVerifierContext().getClassLoader());
            boolean foundAtLeastOne = false;
            try {
                PersistentFieldInfo[] pkFieldInfos = ((EjbCMPEntityDescriptor)descriptor).getPersistenceDescriptor().getPkeyFieldInfo();
                for (int i = 0; i < pkFieldInfos.length; ++i) {
                    foundAtLeastOne = true;
                    PersistentFieldInfo info = pkFieldInfos[i];
                    String setMethodName = "set" + Character.toUpperCase(info.name.charAt(0)) + info.name.substring(1);
                    Class[] parms = new Class[]{info.type};
                    Method setMethod = CmpFieldsAccessorExposition.getMethod(c, setMethodName, parms);
                    if (setMethod != null) {
                        this.result.addWarningDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                        this.result.addWarningDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CmpFieldsAccessorExposition.failed", "Error : Primary key field set accessor method [ {0} ] is exposed through the component interface [ {1} ]", new Object[]{info.name, remote}));
                        oneFailed = true;
                        continue;
                    }
                    this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addGoodDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CmpFieldsAccessorExposition.passed", "Primary key field set accessor method [ {0} ] is not exposed through the component interface [ {1} ]", new Object[]{info.name, remote}));
                }
                if (!foundAtLeastOne) {
                    this.result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                    this.result.addGoodDetails(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CmpFieldsAccessorExposition.notApplicable", "No persistent fields found.", new Object[0]));
                    return oneFailed;
                }
            }
            catch (RuntimeException rt) {
                this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
                this.result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CmpFieldsAccessorExposition.failedException1", "Exception occured while trying to access Primary key info in PersistenceDescriptor.", new Object[0]));
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{this.compName.toString()}));
            this.result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.EjbTest.failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
            oneFailed = true;
            return oneFailed;
        }
    }
}

