/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.managed;

import com.sun.enterprise.deployment.ConnectionDefDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.OutboundResourceAdapter;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.Set;

public class CheckConnectionImplClass
extends ConnectorTest
implements ConnectorCheck {
    public Result check(ConnectorDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        if (!descriptor.getOutBoundDefined()) {
            result.addNaDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.notApplicable(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.managed.notApplicableForInboundRA", "Resource Adapter does not provide outbound communication"));
            return result;
        }
        OutboundResourceAdapter outboundRA = descriptor.getOutboundResourceAdapter();
        if (outboundRA == null) {
            return null;
        }
        boolean oneFailed = false;
        Set connDefs = outboundRA.getConnectionDefs();
        for (ConnectionDefDescriptor connDefDesc : connDefs) {
            String connectionInterface = connDefDesc.getConnectionIntf();
            String connectionImpl = connDefDesc.getConnectionImpl();
            Class<?> implClass = null;
            try {
                implClass = Class.forName(connectionImpl, false, this.getVerifierContext().getClassLoader());
            }
            catch (ClassNotFoundException e) {
                result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
                result.failed(smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: The class [ {0} ] as defined under connection-impl-class in the deployment descriptor does not exist", new Object[]{connectionImpl}));
                return result;
            }
            if (CheckConnectionImplClass.isImplementorOf(implClass, connectionInterface)) continue;
            oneFailed = true;
            result.addErrorDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Error: connection-impl-class [ {0} ] does not implement connection-interface [ {1} ].", new Object[]{implClass.getName(), connectionInterface}));
            return result;
        }
        if (!oneFailed) {
            result.addGoodDetails(smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{compName.toString()}));
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Success: all connection-impl-class implement their corresponding connection-interface"));
        }
        return result;
    }
}

