/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.appclient;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientCheck;
import com.sun.enterprise.tools.verifier.tests.appclient.AppClientTest;
import java.lang.reflect.Modifier;

public class AppClientMainClass
extends AppClientTest
implements AppClientCheck {
    public Result check(ApplicationClientDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        String mainClass = descriptor.getMainClassName();
        if (mainClass != null && mainClass.length() > 0) {
            try {
                Class<?> c = Class.forName(mainClass, false, this.getVerifierContext().getClassLoader());
                if (!Modifier.isPublic(c.getModifiers())) {
                    this.addErrorDetails(result, compName);
                    result.failed(smh.getLocalString(this.getClass().getName() + ".failed2", "ERROR: Appclient main-class [ {0} ] as specified in the Manifest file is not public.", new Object[]{mainClass}));
                }
            }
            catch (ClassNotFoundException cnfe) {
                if (this.debug) {
                    cnfe.printStackTrace();
                }
                this.addErrorDetails(result, compName);
                result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "ERROR: Appclient main-class [ {0} ] as specified in the Manifest file is not loadable.", new Object[]{mainClass}));
            }
        } else {
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed", "Appclient main-class is not found. Please check the main-class entry of your appclient manifest file."));
        }
        if (result.getStatus() != 1) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "main-class entry is defined properly."));
        }
        return result;
    }
}

