/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.connector;

import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.SpecVersionMapper;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.apiscan.classfile.ClassFileLoaderFactory;
import com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.ConnectorClosureCompiler;
import com.sun.enterprise.tools.verifier.connector.ConnectorCheckMgrImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;

public class ConnectorVerifier
extends BaseVerifier {
    private ConnectorDescriptor cond = null;
    private String classPath;
    private boolean isASMode = false;

    public ConnectorVerifier(VerifierFrameworkContext verifierFrameworkContext, ConnectorDescriptor cond) {
        this.verifierFrameworkContext = verifierFrameworkContext;
        this.cond = cond;
        this.isASMode = !verifierFrameworkContext.isPortabilityMode();
    }

    public void verify() throws Exception {
        if (this.areTestsNotRequired(this.verifierFrameworkContext.isConnector())) {
            return;
        }
        this.preVerification();
        this.createClosureCompiler();
        this.verify((Descriptor)this.cond, new ConnectorCheckMgrImpl(this.verifierFrameworkContext));
    }

    public Descriptor getDescriptor() {
        return this.cond;
    }

    protected ClassLoader createClassLoader() throws IOException {
        return this.cond.getClassLoader();
    }

    protected String getArchiveUri() {
        return FileUtils.makeFriendlyFilename((String)this.cond.getModuleDescriptor().getArchiveUri());
    }

    protected String[] getDDString() {
        String[] dd = new String[]{"META-INF/sun-ra.xml", "META-INF/ra.xml"};
        return dd;
    }

    protected String getClassPath() throws IOException {
        String cp;
        if (this.classPath != null) {
            return this.classPath;
        }
        if (this.isASMode) {
            this.classPath = this.getClassPath(this.verifierFrameworkContext.getClassPath());
            return this.classPath;
        }
        if (!this.cond.getModuleDescriptor().isStandalone()) {
            String ear_uri = this.verifierFrameworkContext.getExplodedArchivePath();
            File ear = new File(ear_uri);
            assert (ear.isDirectory());
            cp = ClassPathBuilder.buildClassPathForEar(ear);
            String libdir = this.cond.getApplication().getLibraryDirectory();
            if (libdir != null) {
                cp = this.getLibdirClasspath(ear_uri, libdir) + cp;
            }
        } else {
            String module_uri = this.verifierFrameworkContext.getExplodedArchivePath();
            File module = new File(module_uri);
            assert (module.isDirectory() && module.isAbsolute());
            cp = ClassPathBuilder.buildClassPathForRar(module);
        }
        this.classPath = cp;
        return this.classPath;
    }

    protected void createClosureCompiler() throws IOException {
        String specVer = SpecVersionMapper.getJCAVersion(this.verifierFrameworkContext.getJavaEEVersion());
        Object arg = this.isASMode ? this.cond.getClassLoader() : this.getClassPath();
        ConnectorClosureCompiler cc = new ConnectorClosureCompiler(specVer, ClassFileLoaderFactory.newInstance(new Object[]{arg}));
        this.context.setClosureCompiler(cc);
    }
}

