/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.apiscan.packaging;

import com.sun.enterprise.tools.verifier.apiscan.packaging.Archive;
import com.sun.enterprise.tools.verifier.apiscan.packaging.ExtensionRef;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClassPathBuilder {
    private static String resourceBundleName = "com.sun.enterprise.tools.verifier.apiscan.LocalStrings";
    public static final Logger logger = Logger.getLogger("apiscan.packaging", resourceBundleName);
    private static final String myClassName = "ClassPathBuilder";
    private static final String thisClassName = "com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder";

    public static String buildClassPathForJar(JarFile jar) throws IOException {
        return ClassPathBuilder.buildClassPathForJar(new Archive(jar));
    }

    public static String buildClassPathForJar(File file) throws IOException {
        return ClassPathBuilder.buildClassPathForJar(new Archive(file));
    }

    public static String buildClassPathForRar(File file) throws IOException {
        return ClassPathBuilder.buildClassPathForRar(new Archive(file));
    }

    public static String buildClassPathForJar(Archive jar) throws IOException {
        logger.entering(myClassName, "buildClassPathForJar", jar);
        StringBuffer classpath = new StringBuffer(jar.getPath() + File.pathSeparator);
        Archive[] archives = jar.getBundledArchives();
        classpath.append(ClassPathBuilder.convertToClassPath(archives));
        classpath.append(File.pathSeparator).append(ClassPathBuilder.convertToClassPath(ClassPathBuilder.getInstalledArchivesForJar(jar)));
        String result = ClassPathBuilder.removeDuplicates(classpath).toString();
        logger.exiting(myClassName, "buildClassPathForJar", result);
        return result;
    }

    public static String buildClassPathForRar(Archive rar) throws IOException {
        logger.entering(myClassName, "buildClassPathForRar", rar);
        final StringBuffer classpath = new StringBuffer();
        new File(rar.getPath()).listFiles(new FileFilter(){

            public boolean accept(File file) {
                if (file.getName().endsWith(".jar") && file.isFile()) {
                    classpath.append(File.pathSeparator).append(file.getAbsolutePath());
                    return true;
                }
                return false;
            }
        });
        Archive[] archives = rar.getBundledArchives();
        classpath.append(ClassPathBuilder.convertToClassPath(archives));
        classpath.append(File.pathSeparator).append(ClassPathBuilder.convertToClassPath(ClassPathBuilder.getInstalledArchivesForJar(rar)));
        String result = ClassPathBuilder.removeDuplicates(classpath).toString();
        logger.exiting(myClassName, "buildClassPathForRar", result);
        return result;
    }

    private static Archive[] getInstalledArchivesForJar(Archive jar) throws IOException {
        ArrayList<Archive> list = new ArrayList<Archive>();
        ExtensionRef[] extRefs = jar.getExtensionRefs();
        Archive[] bundled = jar.getBundledArchives();
        Archive[] allOptPkgs = Archive.getAllOptPkgsInstalledInJRE();
        for (int i = 0; i < extRefs.length; ++i) {
            int j;
            ExtensionRef ref = extRefs[i];
            logger.logp(Level.FINE, myClassName, "getInstalledArchivesForJar", "Trying to find an optional package for \n" + ref);
            logger.logp(Level.FINE, myClassName, "getInstalledArchivesForJar", "Searching in the bundled optional package list.");
            Archive satisfyingPkg = null;
            for (j = 0; j < bundled.length; ++j) {
                try {
                    if (!ref.isSatisfiedBy(bundled[j])) continue;
                    satisfyingPkg = bundled[j];
                    logger.logp(Level.INFO, myClassName, "getInstalledArchivesForJar", "com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder.info1", new Object[]{satisfyingPkg.getPath()});
                    break;
                }
                catch (IOException e) {
                    logger.logp(Level.WARNING, myClassName, "getInstalledArchivesForJar", "com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder.exception1", new Object[]{bundled[j].getPath()});
                    logger.log(Level.WARNING, "", e);
                }
            }
            logger.logp(Level.FINE, myClassName, "getInstalledArchivesForJar", "Searching in the installed optional package list.");
            if (satisfyingPkg == null) {
                for (j = 0; j < allOptPkgs.length; ++j) {
                    try {
                        if (!ref.isSatisfiedBy(allOptPkgs[j])) continue;
                        satisfyingPkg = allOptPkgs[j];
                        logger.logp(Level.FINE, myClassName, "buildClassPathForJar", "Found a matching installed optional package " + satisfyingPkg.getPath());
                        break;
                    }
                    catch (IOException e) {
                        logger.logp(Level.WARNING, myClassName, "getInstalledArchivesForJar", "com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder.exception1", new Object[]{allOptPkgs[j].getPath()});
                        logger.log(Level.WARNING, "", e);
                    }
                }
            }
            if (satisfyingPkg != null) {
                list.add(satisfyingPkg);
                continue;
            }
            logger.logp(Level.WARNING, myClassName, "buildClassPathForEar", "com.sun.enterprise.tools.verifier.apiscan.packaging.ClassPathBuilder.warning1", new Object[]{ref.toString()});
        }
        return list.toArray(new Archive[0]);
    }

    public static String buildClassPathForWar(JarFile war) throws IOException {
        return ClassPathBuilder.buildClassPathForWar(new Archive(war));
    }

    public static String buildClassPathForWar(File file) throws IOException {
        return ClassPathBuilder.buildClassPathForWar(new Archive(file));
    }

    public static String buildClassPathForWar(Archive war) throws IOException {
        final StringBuffer cp = new StringBuffer();
        if (new File(war.getPath()).isDirectory()) {
            String explodedDir = war.getPath();
            cp.append(explodedDir + File.separator + "WEB-INF" + File.separator + "classes" + File.separator);
            File[] jarFiles = new File(explodedDir + File.separator + "WEB-INF" + File.separator + "lib").listFiles(new FileFilter(){

                public boolean accept(File file) {
                    if (file.getName().endsWith(".jar") && file.isFile()) {
                        cp.append(File.pathSeparator).append(file.getAbsolutePath());
                        return true;
                    }
                    return false;
                }
            });
        } else assert (false);
        Archive[] archives = war.getBundledArchives();
        cp.append(File.pathSeparator).append(ClassPathBuilder.convertToClassPath(archives));
        cp.append(File.pathSeparator).append(ClassPathBuilder.convertToClassPath(ClassPathBuilder.getInstalledArchivesForJar(war)));
        String result = ClassPathBuilder.removeDuplicates(cp).toString();
        logger.exiting(myClassName, "buildClassPathForWar", result);
        return result;
    }

    public static String buildClassPathForEar(JarFile ear) throws IOException {
        return ClassPathBuilder.buildClassPathForEar(new Archive(ear));
    }

    public static String buildClassPathForEar(File fileOrDir) throws IOException {
        return ClassPathBuilder.buildClassPathForEar(new Archive(fileOrDir));
    }

    public static String buildClassPathForEar(Archive jar) throws IOException {
        File[] archives;
        logger.entering(myClassName, "buildClassPathForEar", jar);
        StringBuffer classpath = new StringBuffer();
        ExtensionRef[] extRefs = jar.getExtensionRefs();
        Archive[] allOptPkgs = Archive.getAllOptPkgsInstalledInJRE();
        for (int i = 0; i < extRefs.length; ++i) {
            ExtensionRef ref = extRefs[i];
            logger.logp(Level.FINE, myClassName, "buildClassPathForEar", "Finding an installed optional package matching extension ref\n" + ref);
            Archive satisfyingPkg = null;
            for (int j = 0; j < allOptPkgs.length; ++j) {
                if (!ref.isSatisfiedBy(allOptPkgs[j])) continue;
                satisfyingPkg = allOptPkgs[j];
                break;
            }
            if (satisfyingPkg != null) {
                logger.logp(Level.FINE, myClassName, "buildClassPathForEar", "Found an installed optional package " + satisfyingPkg.getPath());
                if (classpath.length() != 0) {
                    classpath.append(File.pathSeparator);
                }
                classpath.append(satisfyingPkg.getPath());
                try {
                    String depCP = ClassPathBuilder.buildClassPathForJar(satisfyingPkg);
                    classpath.append(File.pathSeparator).append(depCP);
                }
                catch (IOException e) {
                    logger.logp(Level.WARNING, myClassName, "buildClassPathForEar", "Ignoring " + satisfyingPkg.getPath(), e);
                }
                continue;
            }
            logger.logp(Level.WARNING, myClassName, "buildClassPathForEar", "Could not find an installed optional package for \n" + ref);
        }
        for (File archive : archives = new File(jar.getPath()).listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith("_rar");
            }
        })) {
            String rarCP = ClassPathBuilder.buildClassPathForRar(archive);
            classpath.append(File.pathSeparator).append(rarCP);
        }
        String result = ClassPathBuilder.removeDuplicates(classpath).toString();
        logger.exiting(myClassName, "buildClassPath", result);
        return result;
    }

    private static StringBuffer convertToClassPath(Archive[] archives) {
        StringBuffer cp = new StringBuffer();
        for (int i = 0; i < archives.length; ++i) {
            if (i != 0) {
                cp.append(File.pathSeparatorChar);
            }
            cp.append(archives[i].getPath());
        }
        return cp;
    }

    private static StringBuffer removeDuplicates(StringBuffer cp) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(cp.toString(), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String next = st.nextToken();
            if (tokens.contains(next)) continue;
            tokens.add(next);
        }
        StringBuffer result = new StringBuffer();
        for (int j = 0; j < tokens.size(); ++j) {
            if (j != 0) {
                result.append(File.pathSeparator);
            }
            result.append((String)tokens.get(j));
        }
        return result;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage : java " + ClassPathBuilder.class.getName() + " <path(s) to jar files>");
        }
        Logger logger = Logger.getLogger("apiscan");
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(Level.ALL);
        logger.addHandler(h);
        logger.setLevel(Level.ALL);
        for (int i = 0; i < args.length; ++i) {
            String jarFileName = args[i];
            try {
                System.out.println("Building CLASSPATH for " + jarFileName);
                String classPath = jarFileName.endsWith(".ear") ? ClassPathBuilder.buildClassPathForEar(new Archive(new File(jarFileName))) : ClassPathBuilder.buildClassPathForJar(new Archive(new File(jarFileName)));
                System.out.println("CLASSPATH for For " + jarFileName + "\n [" + classPath + "]");
                continue;
            }
            catch (Exception e) {
                System.out.println("For " + jarFileName + " got the following exception");
                e.printStackTrace();
            }
        }
    }
}

