/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.BaseVerifier;
import com.sun.enterprise.tools.verifier.DescriptorFactory;
import com.sun.enterprise.tools.verifier.ReportHandler;
import com.sun.enterprise.tools.verifier.ResultManager;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.VerifierFrameworkContext;
import com.sun.enterprise.tools.verifier.apiscan.stdapis.APIRepository;
import com.sun.enterprise.tools.verifier.app.ApplicationVerifier;
import com.sun.enterprise.tools.verifier.appclient.AppClientVerifier;
import com.sun.enterprise.tools.verifier.connector.ConnectorVerifier;
import com.sun.enterprise.tools.verifier.ejb.EjbVerifier;
import com.sun.enterprise.tools.verifier.util.LogDomains;
import com.sun.enterprise.tools.verifier.web.WebVerifier;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.deployment.common.InstalledLibrariesResolver;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public class Verifier
implements org.glassfish.internal.deployment.Verifier {
    @Inject
    private DescriptorFactory descriptorFactory;
    @Inject
    private ClassLoaderHierarchy clh;
    @Inject
    private ServerEnvironment env;
    private Application application = null;
    private static boolean debug = false;
    private static Logger logger = LogDomains.getLogger("javax.enterprise.system.tools.avk.tools.verifier");
    private LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    private final String TMPDIR = System.getProperty("java.io.tmpdir");
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyyMMddhhmmss");
    private String explodeDirName = this.TMPDIR + File.separator + "exploded" + this.dateFormatter.format(new Date());
    private VerifierFrameworkContext verifierFrameworkContext = null;

    public void verify(DeploymentContext context) {
        VerifierFrameworkContext verifierFrameworkContext = new VerifierFrameworkContext();
        verifierFrameworkContext.setArchive((Archive)context.getSource());
        verifierFrameworkContext.setApplication((Application)context.getModuleMetaData(Application.class));
        verifierFrameworkContext.setJarFileName(context.getSourceDir().getAbsolutePath());
        verifierFrameworkContext.setJspOutDir(context.getScratchDir("jsp"));
        verifierFrameworkContext.setIsBackend(true);
        verifierFrameworkContext.setOutputDirName(this.env.getDomainRoot().getAbsolutePath() + "/logs/verifier-results");
        ResultManager rm = verifierFrameworkContext.getResultManager();
        try {
            this.init(verifierFrameworkContext);
            this.verify();
        }
        catch (Exception e) {
            LogRecord logRecord = new LogRecord(Level.SEVERE, "Could not verify successfully.");
            logRecord.setThrown(e);
            verifierFrameworkContext.getResultManager().log(logRecord);
        }
        try {
            this.generateReports();
        }
        catch (IOException ioe) {
            context.getLogger().log(Level.WARNING, "Can not generate verifier report: {0}", ioe.getMessage());
        }
        int failedCount = rm.getFailedCount() + rm.getErrorCount();
        if (failedCount != 0) {
            ((ExtendedDeploymentContext)context).clean();
            throw new DeploymentException(this.smh.getLocalString("deploy.failverifier", "Some verifier tests failed. Aborting deployment"));
        }
    }

    public void deployed(DeploymentContext context) {
    }

    public void init(VerifierFrameworkContext verifierFrameworkContext) throws IOException {
        this.verifierFrameworkContext = verifierFrameworkContext;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/sun/enterprise/tools/verifier/config/standard-apis.xml");
        try {
            APIRepository.Initialize(is);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        if (!verifierFrameworkContext.isBackend()) {
            try {
                this.initStandalone();
            }
            catch (IOException ioe) {
                this.cleanup();
                throw ioe;
            }
            catch (RuntimeException re) {
                this.cleanup();
                throw re;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verify() throws IOException {
        assert (this.verifierFrameworkContext != null);
        try {
            this.verifyArchive();
        }
        finally {
            this.cleanup();
        }
    }

    public void generateReports() throws IOException {
        new ReportHandler(this.verifierFrameworkContext).generateAllReports();
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void debug(Throwable t) {
        logger.log(Level.FINEST, "Exception occurred", t);
    }

    private void verifyArchive() {
        if (!this.getApplication().isVirtual()) {
            this.runVerifier(new ApplicationVerifier(this.verifierFrameworkContext));
        }
        for (EjbBundleDescriptor ejbd : this.getApplication().getEjbBundleDescriptors()) {
            this.runVerifier(new EjbVerifier(this.verifierFrameworkContext, ejbd));
        }
        for (WebBundleDescriptor webd : this.getApplication().getWebBundleDescriptors()) {
            this.runVerifier(new WebVerifier(this.verifierFrameworkContext, webd));
        }
        for (ApplicationClientDescriptor appClientDescriptor : this.getApplication().getApplicationClientDescriptors()) {
            this.runVerifier(new AppClientVerifier(this.verifierFrameworkContext, appClientDescriptor));
        }
        for (ConnectorDescriptor cond : this.getApplication().getRarDescriptors()) {
            this.runVerifier(new ConnectorVerifier(this.verifierFrameworkContext, cond));
        }
    }

    private void initStandalone() throws IOException {
        logger.log(Level.FINE, this.getClass().getName() + ".debug.startingLoadJar");
        this.initVerifierTmpDirs();
        String jarFile = this.verifierFrameworkContext.getJarFileName();
        InstalledLibrariesResolver.initializeInstalledLibRegistry((String)this.env.getLibPath().getAbsolutePath());
        DescriptorFactory.ResultHolder result = this.descriptorFactory.createApplicationDescriptor(new File(jarFile), new File(this.explodeDirName), this.clh.getCommonClassLoader());
        this.verifierFrameworkContext.setApplication(result.application);
        this.verifierFrameworkContext.setArchive(result.archive);
    }

    private void runVerifier(BaseVerifier baseVerifier) {
        try {
            baseVerifier.verify();
        }
        catch (Exception e) {
            this.log("Problem in running tests for :" + baseVerifier.getDescriptor().getName(), e);
        }
    }

    private boolean initVerifierTmpDirs() throws IOException {
        File test = new File(this.explodeDirName);
        if (!test.isDirectory() && !test.getAbsoluteFile().mkdirs()) {
            logger.log(Level.SEVERE, this.getClass().getName() + ".explodedircreateerror", test.getAbsolutePath());
            throw new IOException(this.smh.getLocalString(this.getClass().getName() + ".explodedircreateerror", test.getAbsolutePath()));
        }
        return true;
    }

    public void cleanup() {
        if (!this.verifierFrameworkContext.isBackend() && !new File(this.verifierFrameworkContext.getJarFileName()).isDirectory()) {
            FileUtils.whack((File)new File(this.explodeDirName));
        }
    }

    private void log(String message, Exception e) {
        if (message == null) {
            message = "";
        }
        LogRecord logRecord = new LogRecord(Level.SEVERE, message);
        logRecord.setThrown(e);
        this.verifierFrameworkContext.getResultManager().log(logRecord);
    }

    public Application getApplication() {
        return this.verifierFrameworkContext.getApplication();
    }
}

