/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.ejb30;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Set;

public class BusinessInterfaceException
extends EjbTest {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor compName = this.getVerifierContext().getComponentNameConstructor();
        Set localAndRemoteClassNames = descriptor.getLocalBusinessClassNames();
        localAndRemoteClassNames.addAll(descriptor.getRemoteBusinessClassNames());
        for (String localOrRemoteClass : localAndRemoteClassNames) {
            this.checkForRemoteException(localOrRemoteClass, result, compName);
        }
        if (result.getStatus() != 2) {
            this.addGoodDetails(result, compName);
            result.passed(smh.getLocalString(this.getClass().getName() + ".passed", "Business interface(s) if any are valid."));
        }
        return result;
    }

    private void checkForRemoteException(String className, Result result, ComponentNameConstructor compName) {
        try {
            Method[] methods;
            Class<?> c = Class.forName(className, false, this.getVerifierContext().getClassLoader());
            if (Remote.class.isAssignableFrom(c)) {
                return;
            }
            for (Method method : methods = c.getMethods()) {
                Class<?>[] exceptions;
                for (Class<?> exception : exceptions = method.getExceptionTypes()) {
                    if (!RemoteException.class.isAssignableFrom(exception)) continue;
                    result.getFaultLocation().setFaultyClassAndMethod(method);
                    this.addWarningDetails(result, compName);
                    result.warning(smh.getLocalString(this.getClass().getName() + ".warning", "java.rmi.RemoteException is thrown in method [ {0} ] of business interface [ {1} ]", new Object[]{method.getName(), className}));
                }
            }
        }
        catch (ClassNotFoundException e) {
            Verifier.debug(e);
            this.addErrorDetails(result, compName);
            result.failed(smh.getLocalString(this.getClass().getName() + ".failed1", "[ {0} ] not found.", new Object[]{className}));
        }
    }
}

