/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tests.utils;

import com.sun.enterprise.module.bootstrap.Populator;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.glassfish.tests.utils.ConfigApiTest;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

public class Utils {
    static final String habitatName = "default";
    static final String inhabitantPath = "META-INF/inhabitants";
    Map<String, Habitat> habitats = new HashMap<String, Habitat>();
    public static final Utils instance = new Utils();

    public synchronized Habitat getHabitat(ConfigApiTest test) {
        String fileName = test.getFileName();
        if (this.habitats.containsKey(fileName)) {
            return this.habitats.get(fileName);
        }
        Habitat habitat = Utils.getNewHabitat(test);
        this.habitats.put(fileName, habitat);
        return habitat;
    }

    public static synchronized Habitat getNewHabitat(final ConfigApiTest test) {
        final Habitat habitat = Utils.getNewHabitat();
        final String fileName = test.getFileName();
        ConfigParser configParser = new ConfigParser(habitat);
        new Populator(){

            public void run(ConfigParser parser) {
                long now = System.currentTimeMillis();
                URL url = this.getClass().getClassLoader().getResource(fileName + ".xml");
                if (url != null) {
                    try {
                        DomDocument document = parser.parse(url, test.getDocument(habitat));
                        habitat.addComponent((Object)document);
                        test.decorate(habitat);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Logger.getAnonymousLogger().fine("time to parse domain.xml : " + String.valueOf(System.currentTimeMillis() - now));
                }
            }
        }.run(configParser);
        return habitat;
    }

    public static Habitat getNewHabitat() {
        Properties p = new Properties();
        p.put("com.sun.aas.installRoot", System.getProperty("java.io.tmpdir"));
        p.put("com.sun.aas.instanceRoot", System.getProperty("java.io.tmpdir"));
        StaticModulesRegistry registry = new StaticModulesRegistry(Utils.class.getClassLoader(), new StartupContext(p));
        return registry.createHabitat(habitatName);
    }
}

