/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tests.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.Assertions;

public class ServerUtils {
    public static int getFreePort() throws IllegalStateException {
        int counter = 0;
        while (true) {
            ++counter;
            try {
                ServerSocket socket = new ServerSocket(0);
                int port = socket.getLocalPort();
                socket.setSoTimeout(1);
                socket.setReuseAddress(true);
                socket.close();
                return port;
            }
            catch (IOException e) {
                if (counter < 20) continue;
                throw new IllegalStateException("Cannot open random port, tried 20 times.", e);
            }
            break;
        }
    }

    public static String getLocalIP4Address() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Cannot determine the local address.", e);
        }
    }

    public static File createWar(File warFile, Class<?> ... classes) {
        try {
            WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class)).addClasses((Class[])classes);
            ((ZipExporter)war.as(ZipExporter.class)).exportTo(warFile, true);
            return warFile;
        }
        catch (Exception e) {
            return (File)Assertions.fail((Throwable)e);
        }
    }

    public static String download(URL url) throws IOException {
        Object object = url.getContent();
        if (object instanceof InputStream) {
            try (InputStream input = (InputStream)object;){
                Scanner scanner = new Scanner(input, StandardCharsets.UTF_8);
                try {
                    String string = scanner.nextLine();
                    scanner.close();
                    return string;
                }
                catch (Throwable throwable) {
                    try {
                        scanner.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        return (String)Assertions.fail((String)("Expected input stream, but received this: " + String.valueOf(object)));
    }

    public static CommandResult runCommand(GlassFish glassfish, String cmd, String params) throws GlassFishException {
        return glassfish.getCommandRunner().run(cmd, new String[]{params});
    }
}

