/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tests.utils.junit.matcher;

import java.io.File;
import java.nio.file.NotDirectoryException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.junit.jupiter.api.Assertions;

public final class DirectoryMatchers {
    private DirectoryMatchers() {
        throw new AssertionError();
    }

    public static Matcher<File> hasEntryCount(long expected) {
        return DirectoryMatchers.hasEntryCount((Matcher<Long>)CoreMatchers.equalTo((Object)expected));
    }

    public static Matcher<File> hasEntryCount(final Matcher<Long> expected) {
        return new TypeSafeDiagnosingMatcher<File>(){

            public void describeTo(Description description) {
                description.appendText("A directory with a number of entries: ").appendDescriptionOf((SelfDescribing)expected);
            }

            protected boolean matchesSafely(File file, Description mismatchDescription) {
                String[] entries = file.list();
                if (entries != null) {
                    long entryCount = entries.length;
                    boolean matches = expected.matches((Object)entryCount);
                    if (!matches) {
                        expected.describeMismatch((Object)entryCount, mismatchDescription);
                    }
                    return matches;
                }
                return (Boolean)Assertions.fail((Throwable)new NotDirectoryException(file.getName()));
            }
        };
    }
}

