/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.webservices;

import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WebServiceEndpoint;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.ee.audit.AppServerAuditManager;
import com.sun.enterprise.security.ee.authorize.PolicyContextHandlerImpl;
import com.sun.enterprise.security.ee.web.integration.WebPrincipal;
import com.sun.enterprise.security.webservices.LogUtils;
import com.sun.enterprise.security.webservices.client.ClientSecurityPipeCreator;
import com.sun.enterprise.util.Utility;
import com.sun.enterprise.web.WebModule;
import com.sun.web.security.RealmAdapter;
import com.sun.xml.ws.assembler.metro.dev.ClientPipelineHook;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.security.jacc.PolicyContext;
import jakarta.servlet.http.HttpServletRequest;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.security.common.UserNameAndPassword;
import org.glassfish.webservices.EjbRuntimeEndpointInfo;
import org.glassfish.webservices.SecurityService;
import org.glassfish.webservices.WebServiceContextImpl;
import org.glassfish.webservices.monitoring.AuthenticationListener;
import org.glassfish.webservices.monitoring.Endpoint;
import org.glassfish.webservices.monitoring.WebServiceEngineImpl;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class SecurityServiceImpl
implements SecurityService {
    protected static final Logger _logger = LogUtils.getLogger();
    private static final String AUTHORIZATION_HEADER = "authorization";
    @Inject
    private AppServerAuditManager auditManager;

    public boolean doSecurity(HttpServletRequest request, EjbRuntimeEndpointInfo endpointInfo, String realmName, WebServiceContextImpl context) {
        boolean authenticated = false;
        try {
            String method = request.getMethod();
            if (context != null) {
                context.setUserPrincipal(null);
            }
            WebServiceEndpoint endpoint = endpointInfo.getEndpoint();
            String rawAuthInfo = request.getHeader(AUTHORIZATION_HEADER);
            if (method.equals("GET") || !endpoint.hasAuthMethod()) {
                boolean bl = true;
                return bl;
            }
            WebPrincipal webPrincipal = null;
            String endpointName = endpoint.getEndpointName();
            if (endpoint.hasBasicAuth() || rawAuthInfo != null) {
                if (rawAuthInfo == null) {
                    this.sendAuthenticationEvents(false, request.getRequestURI(), null);
                    boolean bl = false;
                    return bl;
                }
                UserNameAndPassword usernamePassword = this.parseUsernameAndPassword(rawAuthInfo);
                if (usernamePassword == null) {
                    _logger.log(Level.WARNING, "AS-WSSECURITY-00009", endpointName);
                } else {
                    webPrincipal = new WebPrincipal(usernamePassword, SecurityContext.init());
                }
            } else {
                Object[] certificates = (X509Certificate[])request.getAttribute("jakarta.servlet.request.X509Certificate");
                if (Utility.isEmpty((Object[])certificates)) {
                    certificates = (X509Certificate[])request.getAttribute("org.apache.coyote.request.X509Certificate");
                }
                if (certificates == null) {
                    _logger.log(Level.WARNING, "AS-WSSECURITY-00010", endpointName);
                } else {
                    webPrincipal = new WebPrincipal((X509Certificate[])certificates, SecurityContext.init());
                }
            }
            if (webPrincipal == null) {
                this.sendAuthenticationEvents(false, request.getRequestURI(), null);
                boolean certificates = authenticated;
                return certificates;
            }
            RealmAdapter realmAdapter = new RealmAdapter(realmName, endpoint.getBundleDescriptor().getModuleID());
            authenticated = realmAdapter.authenticate(request, webPrincipal);
            if (authenticated) {
                this.sendAuthenticationEvents(true, request.getRequestURI(), (Principal)webPrincipal);
            } else {
                this.sendAuthenticationEvents(false, request.getRequestURI(), (Principal)webPrincipal);
                _logger.log(Level.FINE, "authentication failed for {0}", endpointName);
            }
            endpointInfo.prepareInvocation(false);
            WebServiceContextImpl webServiceContext = (WebServiceContextImpl)endpointInfo.getWebServiceContext();
            webServiceContext.setUserPrincipal((Principal)webPrincipal);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (this.auditManager != null && this.auditManager.isAuditOn()) {
                this.auditManager.ejbAsWebServiceInvocation(endpointInfo.getEndpoint().getEndpointName(), authenticated);
            }
        }
        return authenticated;
    }

    public void resetSecurityContext() {
        SecurityContext.setUnauthenticatedContext();
    }

    public void resetPolicyContext() {
        PolicyContextHandlerImpl.getInstance().reset();
        PolicyContext.setContextID(null);
    }

    public ClientPipelineHook getClientPipelineHook(ServiceReferenceDescriptor ref) {
        return new ClientSecurityPipeCreator(ref);
    }

    public Principal getUserPrincipal(boolean isWeb) {
        SecurityContext securityContext = SecurityContext.getCurrent();
        if (securityContext == null) {
            return null;
        }
        if (securityContext.didServerGenerateCredentials() && isWeb) {
            return null;
        }
        return securityContext.getCallerPrincipal();
    }

    public boolean isUserInRole(WebModule webModule, Principal principal, String servletName, String role) {
        if (webModule.getRealm() instanceof RealmAdapter) {
            RealmAdapter realmAdapter = (RealmAdapter)webModule.getRealm();
            return realmAdapter.hasRole(servletName, principal, role);
        }
        return false;
    }

    private UserNameAndPassword parseUsernameAndPassword(String rawAuthInfo) {
        if (rawAuthInfo == null || !rawAuthInfo.startsWith("Basic ")) {
            return null;
        }
        String authString = rawAuthInfo.substring(6).trim();
        String unencoded = new String(Base64.getDecoder().decode(authString.getBytes()));
        int colon = unencoded.indexOf(58);
        if (colon <= 0) {
            return null;
        }
        String user = unencoded.substring(0, colon).trim();
        String password = unencoded.substring(colon + 1).trim();
        return new UserNameAndPassword(user, password);
    }

    private void sendAuthenticationEvents(boolean success, String url, Principal principal) {
        Endpoint endpoint = WebServiceEngineImpl.getInstance().getEndpoint(url);
        if (endpoint == null) {
            return;
        }
        for (AuthenticationListener listener : WebServiceEngineImpl.getInstance().getAuthListeners()) {
            if (success) {
                listener.authSucess(endpoint.getDescriptor().getBundleDescriptor(), endpoint, principal);
                continue;
            }
            listener.authFailure(endpoint.getDescriptor().getBundleDescriptor(), endpoint, principal);
        }
    }
}

