/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.security;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.LoginConfiguration;
import com.sun.enterprise.security.AppCNonceCacheMap;
import com.sun.enterprise.security.CNonceCacheFactory;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.WebSecurityDeployerProbeProvider;
import com.sun.enterprise.security.auth.digest.api.DigestAlgorithmParameter;
import com.sun.enterprise.security.auth.digest.api.Key;
import com.sun.enterprise.security.auth.digest.impl.DigestParameterGenerator;
import com.sun.enterprise.security.auth.digest.impl.HttpAlgorithmParameterImpl;
import com.sun.enterprise.security.auth.digest.impl.NestedDigestAlgoParamImpl;
import com.sun.enterprise.security.auth.login.DigestCredentials;
import com.sun.enterprise.security.auth.login.LoginContextDriver;
import com.sun.enterprise.security.authorize.PolicyContextHandlerImpl;
import com.sun.enterprise.security.ee.SecurityUtil;
import com.sun.enterprise.security.integration.RealmInitializer;
import com.sun.enterprise.security.jmac.config.HttpServletHelper;
import com.sun.enterprise.security.web.integration.WebPrincipal;
import com.sun.enterprise.security.web.integration.WebSecurityManager;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.logging.LogDomains;
import com.sun.web.security.HttpRequestWrapper;
import com.sun.web.security.HttpResponseWrapper;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.security.auth.Subject;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.config.ServerAuthConfig;
import javax.security.auth.message.config.ServerAuthContext;
import javax.security.jacc.PolicyContext;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.AuthenticatorBase;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.realm.RealmBase;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.config.dom.NetworkListeners;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.internal.api.ServerContext;
import org.glassfish.security.common.CNonceCache;
import org.glassfish.security.common.NonceInfo;
import org.jvnet.hk2.annotations.Service;
import sun.security.x509.X500Name;

@Service
@PerLookup
public class RealmAdapter
extends RealmBase
implements RealmInitializer,
PostConstruct {
    private static final Logger _logger = LogDomains.getLogger(RealmAdapter.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle rb = _logger.getResourceBundle();
    public static final String SECURITY_CONTEXT = "SecurityContext";
    public static final String BASIC = "BASIC";
    public static final String FORM = "FORM";
    private static final String SERVER_AUTH_CONTEXT = "__javax.security.auth.message.ServerAuthContext";
    private static final String MESSAGE_INFO = "__javax.security.auth.message.MessageInfo";
    private static final WebSecurityDeployerProbeProvider websecurityProbeProvider = new WebSecurityDeployerProbeProvider();
    private static final String SYSTEM_HTTPSERVLET_SECURITY_PROVIDER = "system_httpservlet_security_provider";
    private WebBundleDescriptor webDesc = null;
    private HashMap<String, String> runAsPrincipals = null;
    private String _realmName = null;
    protected static final String name = "J2EE-RI-RealmAdapter";
    private String CONTEXT_ID = null;
    private Container virtualServer;
    protected volatile WebSecurityManager webSecurityManager = null;
    @Inject
    protected WebSecurityManagerFactory webSecurityManagerFactory;
    protected boolean isCurrentURIincluded = false;
    protected final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private boolean contextEvaluated = false;
    private String loginPage = null;
    private String errorPage = null;
    private static final SecurityConstraint[] emptyConstraints = new SecurityConstraint[0];
    private static String defaultSystemProviderID = RealmAdapter.getDefaultSystemProviderID();
    private String moduleID;
    private boolean isSystemApp;
    private HttpServletHelper helper = null;
    private Boolean secExtEnabled = null;
    @Inject
    private ServerContext serverContext;
    @Inject
    private Provider<AppCNonceCacheMap> appCNonceCacheMapProvider;
    @Inject
    private Provider<CNonceCacheFactory> cNonceCacheFactoryProvider;
    @Inject
    @Named(value="default-instance-name")
    private NetworkConfig networkConfig;
    private CNonceCacheFactory cNonceCacheFactory;
    private CNonceCache cnonces;
    private AppCNonceCacheMap haCNonceCacheMap;
    private NetworkListeners nwListeners;
    private static ThreadLocal reentrancyStatus = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new byte[]{0};
        }
    };
    protected static final String CONF_FILE_NAME = "auth.conf";
    protected static final String HTTP_SERVLET_LAYER = "HttpServlet";
    private static String PROXY_AUTH_TYPE = "PLUGGABLE_PROVIDER";

    public RealmAdapter() {
    }

    public RealmAdapter(String realmName, String moduleID) {
        this._realmName = realmName;
        this.moduleID = moduleID;
    }

    public void destroy() {
        super.destroy();
        if (this.helper != null) {
            this.helper.disable();
        }
    }

    public void setVirtualServer(Object container) {
        this.virtualServer = (Container)container;
    }

    public WebBundleDescriptor getWebDescriptor() {
        return this.webDesc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebSecurityManager getWebSecurityManager(boolean logNull) {
        if (this.webSecurityManager == null) {
            RealmAdapter realmAdapter = this;
            synchronized (realmAdapter) {
                this.webSecurityManager = this.webSecurityManagerFactory.getManager(this.CONTEXT_ID, null, false);
            }
            if (this.webSecurityManager == null && logNull) {
                _logger.log(Level.WARNING, "realmAdapter.noWebSecMgr", this.CONTEXT_ID);
            }
        }
        return this.webSecurityManager;
    }

    public void updateWebSecurityManager() {
        if (this.webSecurityManager == null) {
            this.webSecurityManager = this.getWebSecurityManager(true);
        }
        if (this.webSecurityManager != null) {
            try {
                this.webSecurityManager.release();
                this.webSecurityManager.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.webSecurityManager = this.webSecurityManagerFactory.createManager(this.webDesc, true, this.serverContext);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("WebSecurityManager for " + this.CONTEXT_ID + " has been update");
            }
        }
    }

    public boolean hasRole(HttpRequest request, HttpResponse response, Principal principal, String role) {
        WebSecurityManager secMgr = this.getWebSecurityManager(true);
        if (secMgr == null) {
            return false;
        }
        String servletName = this.getCanonicalName(request);
        boolean isGranted = secMgr.hasRoleRefPermission(servletName, role, principal);
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Checking if servlet " + servletName + " with principal " + principal + " has role " + role + " isGranted: " + isGranted);
        }
        return isGranted;
    }

    public boolean hasRole(String servletName, Principal principal, String role) {
        WebSecurityManager secMgr = this.getWebSecurityManager(true);
        if (secMgr == null) {
            return false;
        }
        return secMgr.hasRoleRefPermission(servletName, role, principal);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void logout(HttpRequest req) {
        boolean securityExtensionEnabled = this.isSecurityExtensionEnabled(req.getRequest().getServletContext());
        byte[] alreadyCalled = (byte[])reentrancyStatus.get();
        if (securityExtensionEnabled && this.helper != null && alreadyCalled[0] == 0) {
            alreadyCalled[0] = 1;
            MessageInfo messageInfo = (MessageInfo)req.getRequest().getAttribute(MESSAGE_INFO);
            if (messageInfo == null) {
                messageInfo = new HttpMessageInfo((HttpServletRequest)req.getRequest(), (HttpServletResponse)req.getResponse().getResponse());
            }
            messageInfo.getMap().put("javax.security.auth.message.MessagePolicy.isMandatory", Boolean.TRUE.toString());
            try {
                Subject subject;
                ServerAuthContext sAC = this.helper.getServerAuthContext(messageInfo, null);
                if (sAC == null) return;
                SecurityContext securityContext = SecurityContext.getCurrent();
                Subject subject2 = subject = securityContext.didServerGenerateCredentials() ? new Subject() : securityContext.getSubject();
                if (subject == null) {
                    subject = new Subject();
                }
                if (subject.isReadOnly()) {
                    _logger.log(Level.WARNING, "Read-only subject found during logout processing");
                }
                sAC.cleanSubject(messageInfo, subject);
                return;
            }
            catch (AuthException ex) {
                throw new RuntimeException(ex);
            }
            finally {
                this.doLogout(req, true);
                alreadyCalled[0] = 0;
            }
        } else {
            this.doLogout(req, alreadyCalled[0] == 1);
        }
    }

    private void doLogout(HttpRequest request, boolean extensionEnabled) {
        Context context = request.getContext();
        Authenticator authenticator = null;
        if (context != null) {
            authenticator = context.getAuthenticator();
        }
        if (authenticator == null) {
            throw new RuntimeException("Context or Authenticator is null");
        }
        try {
            if (extensionEnabled) {
                AuthenticatorProxy proxy = new AuthenticatorProxy(authenticator, null, null);
                proxy.logout(request);
            } else {
                authenticator.logout(request);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.logout();
    }

    public void logout() {
        this.setSecurityContext(null);
        this.resetPolicyContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Principal authenticate(HttpServletRequest hreq) {
        try {
            NonceInfo info;
            long count;
            CNonceCache nps;
            DigestParameterGenerator generator = DigestParameterGenerator.getInstance((String)"HttpDigest");
            DigestAlgorithmParameter[] params = generator.generateParameters((AlgorithmParameterSpec)new HttpAlgorithmParameterImpl(hreq));
            Key key = null;
            if (this.cnonces == null) {
                String appName = this.webDesc.getApplication().getAppName();
                RealmAdapter realmAdapter = this;
                synchronized (realmAdapter) {
                    if (this.haCNonceCacheMap == null) {
                        this.haCNonceCacheMap = (AppCNonceCacheMap)this.appCNonceCacheMapProvider.get();
                    }
                    if (this.haCNonceCacheMap != null) {
                        this.cnonces = (CNonceCache)this.haCNonceCacheMap.get((Object)appName);
                    }
                    if (this.cnonces == null) {
                        if (this.cNonceCacheFactory == null) {
                            this.cNonceCacheFactory = (CNonceCacheFactory)this.cNonceCacheFactoryProvider.get();
                        }
                        this.cnonces = this.cNonceCacheFactory.createCNonceCache(this.webDesc.getApplication().getAppName(), null, null, null);
                    }
                }
            }
            String nc = null;
            String cnonce = null;
            for (DigestAlgorithmParameter p : params) {
                if (p instanceof NestedDigestAlgoParamImpl) {
                    NestedDigestAlgoParamImpl np = (NestedDigestAlgoParamImpl)p;
                    for (DigestAlgorithmParameter p1 : nps = (CNonceCache)np.getNestedParams()) {
                        if ("cnonce".equals(p1.getName())) {
                            cnonce = new String(p1.getValue());
                        } else if ("nc".equals(p1.getName())) {
                            nc = new String(p1.getValue());
                        }
                        if (cnonce != null && nc != null) break;
                    }
                    if (cnonce != null && nc != null) break;
                }
                if ("cnonce".equals(p.getName())) {
                    cnonce = new String(p.getValue());
                    continue;
                }
                if (!"nc".equals(p.getName())) continue;
                nc = new String(p.getValue());
            }
            long currentTime = System.currentTimeMillis();
            try {
                count = Long.parseLong(nc, 16);
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException(nfe);
            }
            nps = this.cnonces;
            synchronized (nps) {
                info = (NonceInfo)this.cnonces.get((Object)cnonce);
            }
            if (info == null) {
                info = new NonceInfo();
            } else if (count <= info.getCount()) {
                throw new RuntimeException("Invalid Request : Possible Replay Attack detected ?");
            }
            info.setCount(count);
            info.setTimestamp(currentTime);
            nps = this.cnonces;
            synchronized (nps) {
                this.cnonces.put((Object)cnonce, (Object)info);
            }
            for (int i = 0; i < params.length; ++i) {
                DigestAlgorithmParameter dap = params[i];
                if (!"A1".equals(dap.getName()) || !(dap instanceof Key)) continue;
                key = (Key)dap;
                break;
            }
            if (key != null) {
                DigestCredentials creds = new DigestCredentials(this._realmName, key.getUsername(), params);
                LoginContextDriver.login((DigestCredentials)creds);
                SecurityContext secCtx = SecurityContext.getCurrent();
                return new WebPrincipal(creds.getUserName(), (char[])null, secCtx);
            }
            throw new RuntimeException("No key found in parameters");
        }
        catch (Exception le) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.log(Level.WARNING, "web.login.failed", le.toString());
            }
            return null;
        }
    }

    public Principal authenticate(String username, char[] password) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("Tomcat callback for authenticate user/password");
            _logger.fine("usename = " + username);
        }
        if (this.authenticate(username, password, null)) {
            SecurityContext secCtx = SecurityContext.getCurrent();
            assert (secCtx != null);
            return new WebPrincipal(username, password, secCtx);
        }
        return null;
    }

    public Principal authenticate(X509Certificate[] certs) {
        if (this.authenticate(null, null, certs)) {
            SecurityContext secCtx = SecurityContext.getCurrent();
            assert (secCtx != null);
            return new WebPrincipal(certs, secCtx);
        }
        return null;
    }

    public boolean authenticate(WebPrincipal prin) {
        if (prin.isUsingCertificate()) {
            return this.authenticate(null, null, prin.getCertificates());
        }
        return this.authenticate(prin.getName(), prin.getPassword(), null);
    }

    protected boolean authenticate(String username, char[] password, X509Certificate[] certs) {
        boolean success;
        block5: {
            String realm_name = null;
            success = false;
            try {
                if (certs != null) {
                    Subject subject = new Subject();
                    X509Certificate certificate = certs[0];
                    X500Name x500Name = (X500Name)certificate.getSubjectDN();
                    subject.getPublicCredentials().add(x500Name);
                    List<X509Certificate> certificateCred = Arrays.asList(certs);
                    subject.getPublicCredentials().add(certificateCred);
                    LoginContextDriver.doX500Login((Subject)subject, (String)this.moduleID);
                    realm_name = "certificate";
                } else {
                    realm_name = this._realmName;
                    LoginContextDriver.login((String)username, (char[])password, (String)realm_name);
                }
                success = true;
            }
            catch (Exception le) {
                success = false;
                if (!_logger.isLoggable(Level.WARNING)) break block5;
                _logger.log(Level.WARNING, "web.login.failed", le.toString());
                if (!_logger.isLoggable(Level.FINE)) break block5;
                _logger.log(Level.FINE, "Exception", le);
            }
        }
        if (success && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "Web login succeeded for: " + username);
        }
        return success;
    }

    public void preSetRunAsIdentity(ComponentInvocation inv) {
        if (this.runAsPrincipals != null && this.runAsPrincipals.isEmpty()) {
            return;
        }
        String servletName = this.getServletName(inv);
        if (servletName == null) {
            return;
        }
        String runAs = this.runAsPrincipals.get(servletName);
        if (runAs != null) {
            SecurityContext old = this.getSecurityContext();
            inv.setOldSecurityContext((Object)old);
            this.loginForRunAs(runAs);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("run-as principal for " + servletName + " set to: " + runAs);
            }
        }
    }

    private String getServletName(ComponentInvocation inv) {
        HttpServlet thisServlet;
        ServletConfig svc;
        String servletName = inv.getInstanceName();
        if (servletName != null) {
            return servletName;
        }
        Object invInstance = inv.getInstance();
        if (invInstance instanceof HttpServlet && (svc = (thisServlet = (HttpServlet)invInstance).getServletConfig()) != null) {
            return thisServlet.getServletName();
        }
        return null;
    }

    public void postSetRunAsIdentity(ComponentInvocation inv) {
        if (this.runAsPrincipals != null && this.runAsPrincipals.isEmpty()) {
            return;
        }
        String servletName = this.getServletName(inv);
        if (servletName == null) {
            return;
        }
        String runAs = this.runAsPrincipals.get(servletName);
        if (runAs != null) {
            this.setSecurityContext((SecurityContext)inv.getOldSecurityContext());
        }
    }

    private void loginForRunAs(String principal) {
        LoginContextDriver.loginPrincipal((String)principal, (String)this._realmName);
    }

    private SecurityContext getSecurityContext() {
        return SecurityContext.getCurrent();
    }

    private void setSecurityContext(SecurityContext sc) {
        SecurityContext.setCurrent((SecurityContext)sc);
    }

    private boolean principalSetContainsOnlyAnonymousPrincipal(Set<Principal> principalSet) {
        boolean rvalue = false;
        Principal defaultPrincipal = SecurityContext.getDefaultCallerPrincipal();
        if (defaultPrincipal != null && principalSet != null) {
            rvalue = principalSet.contains(defaultPrincipal);
        }
        if (rvalue) {
            Iterator<Principal> it = principalSet.iterator();
            while (it.hasNext()) {
                if (it.next().equals(defaultPrincipal)) continue;
                return false;
            }
        }
        return rvalue;
    }

    protected char[] getPassword(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    protected Principal getPrincipal(String username) {
        throw new IllegalStateException("Should not reach here");
    }

    public Principal createFailOveredPrincipal(String username) {
        _logger.log(Level.FINEST, "IN createFailOveredPrincipal (" + username + ")");
        this.loginForRunAs(username);
        SecurityContext secCtx = SecurityContext.getCurrent();
        _logger.log(Level.FINE, "Security context is " + secCtx);
        assert (secCtx != null);
        WebPrincipal principal = new WebPrincipal(username, (char[])null, secCtx);
        _logger.log(Level.INFO, "Principal created for FailOvered user " + principal);
        return principal;
    }

    public boolean hasResourcePermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, Context context) throws IOException {
        boolean isGranted = false;
        try {
            isGranted = this.invokeWebSecurityManager(request, response, constraints);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "web_server.excep_authenticate_realmadapter", ex);
            ((HttpServletResponse)response.getResponse()).sendError(503);
            response.setDetailMessage(rb.getString("realmBase.forbidden"));
            return isGranted;
        }
        if (isGranted) {
            return isGranted;
        }
        ((HttpServletResponse)response.getResponse()).sendError(403);
        response.setDetailMessage(rb.getString("realmBase.forbidden"));
        this.invokePostAuthenticateDelegate(request, response, context);
        return isGranted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeWebSecurityManager(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        WebSecurityManager secMgr;
        HttpServletRequest hrequest;
        boolean evaluated = false;
        try {
            this.rwLock.readLock().lock();
            evaluated = this.contextEvaluated;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
        if (!evaluated) {
            try {
                this.rwLock.writeLock().lock();
                if (!this.contextEvaluated) {
                    Context context = (Context)this.getContainer();
                    LoginConfig config = context.getLoginConfig();
                    if (config != null && FORM.equals(config.getAuthMethod())) {
                        this.loginPage = config.getLoginPage();
                        this.errorPage = config.getErrorPage();
                    }
                    this.contextEvaluated = true;
                }
            }
            finally {
                this.rwLock.writeLock().unlock();
            }
        }
        if (this.loginPage != null || this.errorPage != null) {
            String requestURI = request.getRequestPathMB().toString();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[Web-Security]  requestURI: " + requestURI + " loginPage: " + this.loginPage);
            }
            if (this.loginPage != null && this.loginPage.equals(requestURI)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Allow access to login page " + this.loginPage);
                }
                return true;
            }
            if (this.errorPage != null && this.errorPage.equals(requestURI)) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Allow access to error page " + this.errorPage);
                }
                return true;
            }
            if (requestURI.endsWith("/j_security_check")) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine(" Allow access to username/password submission");
                }
                return true;
            }
        }
        if ((hrequest = (HttpServletRequest)request).getServletPath() == null) {
            request.setServletPath(this.getResourceName(hrequest.getRequestURI(), hrequest.getContextPath()));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[Web-Security] [ hasResourcePermission ] Principal: " + hrequest.getUserPrincipal() + " ContextPath: " + hrequest.getContextPath());
        }
        if ((secMgr = this.getWebSecurityManager(true)) == null) {
            return false;
        }
        return secMgr.hasResourcePermission(hrequest);
    }

    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints) throws IOException {
        return this.hasUserDataPermission(request, response, constraints, null, null);
    }

    public boolean hasUserDataPermission(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, String uri, String method) throws IOException {
        HttpServletRequest hrequest = (HttpServletRequest)request;
        if (hrequest.getServletPath() == null) {
            request.setServletPath(this.getResourceName(hrequest.getRequestURI(), hrequest.getContextPath()));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("[Web-Security][ hasUserDataPermission ] Principal: " + hrequest.getUserPrincipal() + " ContextPath: " + hrequest.getContextPath());
        }
        if (request.getRequest().isSecure()) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[Web-Security] request.getRequest().isSecure(): " + request.getRequest().isSecure());
            }
            return true;
        }
        WebSecurityManager secMgr = this.getWebSecurityManager(true);
        if (secMgr == null) {
            return false;
        }
        int isGranted = 0;
        try {
            isGranted = secMgr.hasUserDataPermission(hrequest, uri, method);
        }
        catch (IllegalArgumentException e) {
            String msgWithId = rb.getString("realmAdapter.badRequestWithId");
            _logger.log(Level.WARNING, msgWithId, e);
            String msg = rb.getString("realmAdapter.badRequest");
            ((HttpServletResponse)response.getResponse()).sendError(400, msg);
            return false;
        }
        if (isGranted == -1) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.fine("[Web-Security] redirecting using SSL");
            }
            return this.redirect(request, response);
        }
        if (isGranted == 0) {
            ((HttpServletResponse)response.getResponse()).sendError(403, rb.getString("realmBase.forbidden"));
            return false;
        }
        return true;
    }

    private List<String> getHostAndPort(HttpRequest request) throws IOException {
        boolean isHostPortNullOrEmpty;
        boolean isWebServerRequest = false;
        Enumeration headerNames = ((HttpServletRequest)request.getRequest()).getHeaderNames();
        String[] hostPort = null;
        boolean isHeaderPresent = false;
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            if (!headerName.equalsIgnoreCase("Host")) continue;
            String hostVal = ((HttpServletRequest)request.getRequest()).getHeader(headerName);
            isHeaderPresent = true;
            hostPort = hostVal.split(":");
        }
        if (hostPort == null) {
            throw new ProtocolException(rb.getString("missing_http_header.host"));
        }
        boolean bl = isHostPortNullOrEmpty = hostPort.length <= 1 || hostPort[1] == null || hostPort[1].trim().isEmpty();
        if (!isHeaderPresent) {
            isWebServerRequest = false;
        } else if (isHostPortNullOrEmpty) {
            isWebServerRequest = true;
        } else {
            boolean breakFromLoop = false;
            for (NetworkListener nwListener : this.nwListeners.getNetworkListener()) {
                String nwAddress = nwListener.getAddress();
                if (nwAddress == null || nwAddress.equals("0.0.0.0")) {
                    nwAddress = NetUtils.getCanonicalHostName();
                    if (!nwAddress.equals(hostPort[0])) {
                        InetAddress[] localHostAdresses = NetUtils.getHostAddresses();
                        InetAddress hostAddress = InetAddress.getByName(hostPort[0]);
                        for (InetAddress inetAdress : localHostAdresses) {
                            if (!inetAdress.equals(hostAddress)) continue;
                            String nwPort = nwListener.getPort();
                            if (!nwPort.equals(hostPort[1])) {
                                isWebServerRequest = true;
                                continue;
                            }
                            isWebServerRequest = false;
                            breakFromLoop = true;
                            break;
                        }
                    } else {
                        String nwPort = nwListener.getPort();
                        if (!nwPort.equals(hostPort[1])) {
                            isWebServerRequest = true;
                        } else {
                            isWebServerRequest = false;
                            breakFromLoop = true;
                        }
                    }
                }
                if (!breakFromLoop || isWebServerRequest) continue;
                break;
            }
        }
        String serverHost = request.getRequest().getServerName();
        int redirectPort = request.getConnector().getRedirectPort();
        if (isWebServerRequest) {
            serverHost = hostPort[0];
            redirectPort = isHostPortNullOrEmpty ? -1 : Integer.parseInt(hostPort[1]);
        }
        ArrayList<String> hostAndPort = new ArrayList<String>();
        hostAndPort.add(serverHost);
        hostAndPort.add(String.valueOf(redirectPort));
        return hostAndPort;
    }

    private boolean redirect(HttpRequest request, HttpResponse response) throws IOException {
        String queryString;
        HttpServletRequest hrequest = (HttpServletRequest)request.getRequest();
        HttpServletResponse hresponse = (HttpServletResponse)response.getResponse();
        int redirectPort = request.getConnector().getRedirectPort();
        if (redirectPort <= 0) {
            if (_logger.isLoggable(Level.INFO)) {
                _logger.fine("[Web-Security]  SSL redirect is disabled");
            }
            hresponse.sendError(403, URLEncoder.encode(hrequest.getRequestURI(), "UTF-8"));
            return false;
        }
        String protocol = "https";
        StringBuffer file = new StringBuffer(hrequest.getRequestURI());
        String requestedSessionId = hrequest.getRequestedSessionId();
        if (requestedSessionId != null && hrequest.isRequestedSessionIdFromURL()) {
            file.append(";jsessionid=");
            file.append(requestedSessionId);
        }
        if ((queryString = hrequest.getQueryString()) != null) {
            file.append('?');
            file.append(queryString);
        }
        URL url = null;
        List<String> hostAndPort = this.getHostAndPort(request);
        String serverHost = hostAndPort.get(0);
        redirectPort = Integer.valueOf(hostAndPort.get(1));
        try {
            url = new URL(protocol, serverHost, redirectPort, file.toString());
            hresponse.sendRedirect(url.toString());
            return false;
        }
        catch (MalformedURLException e) {
            hresponse.sendError(500, URLEncoder.encode(hrequest.getRequestURI(), "UTF-8"));
            return false;
        }
    }

    private String getCanonicalName(HttpRequest currentRequest) {
        return currentRequest.getWrapper().getServletName();
    }

    private String getResourceName(String uri, String contextPath) {
        if (contextPath.length() < uri.length()) {
            return uri.substring(contextPath.length());
        }
        return "";
    }

    protected String getName() {
        return name;
    }

    public String getRealmName() {
        return this._realmName;
    }

    public void setRealmName(String realmName) {
    }

    public SecurityConstraint[] findSecurityConstraints(HttpRequest request, Context context) {
        WebSecurityManager secMgr;
        if (this.helper == null) {
            this.initConfigHelper(context.getServletContext());
        }
        if ((secMgr = this.getWebSecurityManager(false)) != null && secMgr.hasNoConstrainedResources() && !this.isSecurityExtensionEnabled(context.getServletContext())) {
            return null;
        }
        SecurityConstraint[] constraints = emptyConstraints;
        return constraints;
    }

    public SecurityConstraint[] findSecurityConstraints(String requestPathMB, String httpMethod, Context context) {
        WebSecurityManager secMgr;
        if (this.helper == null) {
            this.initConfigHelper(context.getServletContext());
        }
        if ((secMgr = this.getWebSecurityManager(false)) != null && secMgr.hasNoConstrainedResources() && !this.isSecurityExtensionEnabled(context.getServletContext())) {
            return null;
        }
        SecurityConstraint[] constraints = emptyConstraints;
        return constraints;
    }

    public int preAuthenticateCheck(HttpRequest request, HttpResponse response, SecurityConstraint[] constraints, boolean disableProxyCaching, boolean securePagesWithPragma, boolean ssoEnabled) throws IOException {
        boolean isGranted = false;
        try {
            HttpServletRequest hsr = (HttpServletRequest)request.getRequest();
            if (hsr.getUserPrincipal() == null) {
                SecurityContext.setUnauthenticatedContext();
            }
            if (this.helper != null && this.helper.getServerAuthConfig() != null) {
                return 1;
            }
            isGranted = this.invokeWebSecurityManager(request, response, constraints);
        }
        catch (IOException iex) {
            throw iex;
        }
        catch (Throwable ex) {
            _logger.log(Level.SEVERE, "web_server.excep_authenticate_realmadapter", ex);
            ((HttpServletResponse)response.getResponse()).sendError(503);
            response.setDetailMessage(rb.getString("realmBase.forbidden"));
            return -1;
        }
        if (isGranted) {
            boolean delegateSessionMgmt = false;
            if (((HttpServletRequest)request).getUserPrincipal() != null) {
                this.disableProxyCaching(request, response, disableProxyCaching, securePagesWithPragma);
                if (ssoEnabled) {
                    HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
                    WebSecurityManager webSecMgr = this.getWebSecurityManager(true);
                    if (!webSecMgr.permitAll(hreq)) {
                        hreq.getSession(true);
                    }
                }
            }
            return 0;
        }
        if (((HttpServletRequest)request).getUserPrincipal() != null) {
            ((HttpServletResponse)response.getResponse()).sendError(403);
            response.setDetailMessage(rb.getString("realmBase.forbidden"));
            return -1;
        }
        this.disableProxyCaching(request, response, disableProxyCaching, securePagesWithPragma);
        return 1;
    }

    public boolean invokeAuthenticateDelegate(HttpRequest request, HttpResponse response, Context context, Authenticator authenticator, boolean calledFromAuthenticate) throws IOException {
        boolean result = false;
        LoginConfig config = context.getLoginConfig();
        ServerAuthConfig serverAuthConfig = null;
        try {
            if (this.helper != null) {
                serverAuthConfig = this.helper.getServerAuthConfig();
            }
        }
        catch (Exception ex) {
            IOException iex = new IOException();
            iex.initCause(ex);
            throw iex;
        }
        result = serverAuthConfig != null ? this.validate(request, response, config, authenticator, calledFromAuthenticate) : ((AuthenticatorBase)authenticator).authenticate(request, response, config);
        return result;
    }

    public boolean invokePostAuthenticateDelegate(HttpRequest request, HttpResponse response, Context context) throws IOException {
        boolean result = false;
        ServerAuthContext sAC = null;
        try {
            HttpServletRequest req;
            MessageInfo messageInfo;
            if (this.helper != null && (messageInfo = (MessageInfo)(req = (HttpServletRequest)request.getRequest()).getAttribute(MESSAGE_INFO)) != null && (sAC = (ServerAuthContext)messageInfo.getMap().get(SERVER_AUTH_CONTEXT)) != null) {
                AuthStatus authStatus = sAC.secureResponse(messageInfo, null);
                result = AuthStatus.SUCCESS.equals(authStatus);
            }
        }
        catch (AuthException ex) {
            IOException iex = new IOException();
            iex.initCause(ex);
            throw iex;
        }
        finally {
            if (this.helper != null && sAC != null) {
                if (request instanceof HttpRequestWrapper) {
                    request.removeNote("__javax.security.auth.message.request");
                }
                if (response instanceof HttpResponseWrapper) {
                    request.removeNote("__javax.security.auth.message.response");
                }
            }
        }
        return result;
    }

    public boolean isSecurityExtensionEnabled(ServletContext context) {
        if (this.helper == null) {
            this.initConfigHelper(context);
        }
        try {
            return this.helper.getServerAuthConfig() != null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private HttpServletHelper getConfigHelper(ServletContext servletContext) {
        HashMap<String, WebBundleDescriptor> map = new HashMap<String, WebBundleDescriptor>();
        map.put("WEB_BUNDLE", this.webDesc);
        return new HttpServletHelper(this.getAppContextID(servletContext), map, null, this._realmName, this.isSystemApp, defaultSystemProviderID);
    }

    private String getAppContextID(ServletContext servletContext) {
        if (!servletContext.getVirtualServerName().equals(this.virtualServer.getName())) {
            _logger.log(Level.WARNING, "Virtual server name from ServletContext: {0} differs from name from virtual.getName(): {1}", new Object[]{servletContext.getVirtualServerName(), this.virtualServer.getName()});
        }
        if (!servletContext.getContextPath().equals(this.webDesc.getContextRoot())) {
            _logger.log(Level.WARNING, "Context path from ServletContext: {0} differs from path from bundle: {1}", new Object[]{servletContext.getContextPath(), this.webDesc.getContextRoot()});
        }
        return servletContext.getVirtualServerName() + " " + servletContext.getContextPath();
    }

    private boolean validate(HttpRequest request, HttpResponse response, LoginConfig config, Authenticator authenticator, boolean calledFromAuthenticate) throws IOException {
        boolean isMandatory;
        boolean rvalue;
        HttpMessageInfo messageInfo;
        Subject subject;
        HttpServletResponse res;
        HttpServletRequest req;
        block20: {
            req = (HttpServletRequest)request.getRequest();
            res = (HttpServletResponse)response.getResponse();
            subject = new Subject();
            messageInfo = new HttpMessageInfo(req, res);
            rvalue = false;
            isMandatory = true;
            try {
                ServerAuthContext sAC;
                WebSecurityManager webSecMgr = this.getWebSecurityManager(true);
                boolean bl = isMandatory = !webSecMgr.permitAll(req);
                if (isMandatory || calledFromAuthenticate) {
                    messageInfo.getMap().put("javax.security.auth.message.MessagePolicy.isMandatory", Boolean.TRUE.toString());
                }
                if ((sAC = this.helper.getServerAuthContext((MessageInfo)messageInfo, null)) != null) {
                    AuthStatus authStatus = sAC.validateRequest((MessageInfo)messageInfo, subject, null);
                    rvalue = AuthStatus.SUCCESS.equals(authStatus);
                    if (rvalue) {
                        messageInfo.getMap().put(SERVER_AUTH_CONTEXT, sAC);
                        req.setAttribute(MESSAGE_INFO, (Object)messageInfo);
                    }
                    break block20;
                }
                throw new AuthException("null ServerAuthContext");
            }
            catch (AuthException ae) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "JMAC: http msg authentication fail", ae);
                }
                res.setStatus(500);
            }
            catch (RuntimeException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, "JMAC: Exception during validateRequest", e);
                }
                res.sendError(500);
            }
        }
        if (rvalue) {
            block21: {
                Set<Principal> principalSet = subject.getPrincipals();
                if (principalSet != null && !principalSet.isEmpty() && !this.principalSetContainsOnlyAnonymousPrincipal(principalSet)) {
                    SecurityContext ctx = new SecurityContext(subject);
                    Principal p = ctx.getCallerPrincipal();
                    WebPrincipal wp = new WebPrincipal(p, ctx);
                    try {
                        String authType = (String)messageInfo.getMap().get("javax.servlet.http.authType");
                        if (authType == null && config != null && config.getAuthMethod() != null) {
                            authType = config.getAuthMethod();
                        }
                        if (this.shouldRegister(messageInfo.getMap())) {
                            AuthenticatorProxy proxy = new AuthenticatorProxy(authenticator, (Principal)wp, authType);
                            proxy.authenticate(request, response, config);
                            break block21;
                        }
                        request.setAuthType(authType == null ? PROXY_AUTH_TYPE : authType);
                        request.setUserPrincipal((Principal)wp);
                    }
                    catch (LifecycleException le) {
                        _logger.log(Level.SEVERE, "[Web-Security] unable to register session", le);
                    }
                } else {
                    if (((HttpServletRequest)messageInfo.getRequestMessage()).getUserPrincipal() != null) {
                        request.setUserPrincipal(null);
                        request.setAuthType(null);
                    }
                    if (isMandatory) {
                        rvalue = false;
                    }
                }
            }
            if (rvalue) {
                HttpServletResponse newResponse;
                HttpServletRequest newRequest = (HttpServletRequest)messageInfo.getRequestMessage();
                if (newRequest != req) {
                    request.setNote("__javax.security.auth.message.request", (Object)new HttpRequestWrapper(request, newRequest));
                }
                if ((newResponse = (HttpServletResponse)messageInfo.getResponseMessage()) != res) {
                    request.setNote("__javax.security.auth.message.response", (Object)new HttpResponseWrapper(response, newResponse));
                }
            }
        }
        return rvalue;
    }

    private boolean shouldRegister(Map map) {
        return map.containsKey("com.sun.web.RealmAdapter.register") || this.mapEntryToBoolean("javax.servlet.http.registerSession", map);
    }

    private boolean mapEntryToBoolean(String propName, Map map) {
        Object value;
        if (map.containsKey(propName) && (value = map.get(propName)) != null && value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        return false;
    }

    private static String getDefaultSystemProviderID() {
        String p = System.getProperty(SYSTEM_HTTPSERVLET_SECURITY_PROVIDER);
        if (p != null && (p = p.trim()).length() == 0) {
            p = null;
        }
        return p;
    }

    private void resetPolicyContext() {
        ((PolicyContextHandlerImpl)PolicyContextHandlerImpl.getInstance()).reset();
        PolicyContext.setContextID(null);
    }

    public void initializeRealm(Object descriptor, boolean isSystemApp, String realmName) {
        this.isSystemApp = isSystemApp;
        this.webDesc = (WebBundleDescriptor)descriptor;
        Application app = this.webDesc.getApplication();
        LoginConfiguration loginConfig = this.webDesc.getLoginConfiguration();
        this._realmName = app.getRealm();
        if (this._realmName == null && loginConfig != null) {
            this._realmName = loginConfig.getRealmName();
        }
        if (realmName != null && (this._realmName == null || this._realmName.equals(""))) {
            this._realmName = realmName;
        }
        this.CONTEXT_ID = WebSecurityManager.getContextID((WebBundleDescriptor)this.webDesc);
        this.runAsPrincipals = new HashMap();
        for (WebComponentDescriptor wcd : this.webDesc.getWebComponentDescriptors()) {
            RunAsIdentityDescriptor runAsDescriptor = wcd.getRunAsIdentity();
            if (runAsDescriptor == null) continue;
            String principal = runAsDescriptor.getPrincipal();
            String servlet = wcd.getCanonicalName();
            if (principal == null || servlet == null) {
                _logger.warning("web.realmadapter.norunas");
                continue;
            }
            this.runAsPrincipals.put(servlet, principal);
            _logger.fine("Servlet " + servlet + " will run-as: " + principal);
        }
        this.moduleID = this.webDesc.getModuleID();
    }

    protected void configureSecurity(WebBundleDescriptor wbd, boolean isSystem) {
        try {
            this.webSecurityManagerFactory.createManager(wbd, true, this.serverContext);
            String context = WebSecurityManager.getContextID((WebBundleDescriptor)wbd);
            SecurityUtil.generatePolicyFile((String)context);
            if (isSystem && context.equals("__admingui/__admingui")) {
                websecurityProbeProvider.policyCreationEvent(context);
            }
        }
        catch (Exception ce) {
            _logger.log(Level.SEVERE, "policy.configure", ce);
            throw new RuntimeException(ce);
        }
    }

    private SecurityContext getSecurityContextForPrincipal(final Principal p) {
        if (p == null) {
            return null;
        }
        if (p instanceof WebPrincipal) {
            return ((WebPrincipal)p).getSecurityContext();
        }
        return AccessController.doPrivileged(new PrivilegedAction<SecurityContext>(){

            @Override
            public SecurityContext run() {
                Subject s = new Subject();
                s.getPrincipals().add(p);
                return new SecurityContext(p.getName(), s);
            }
        });
    }

    public void setCurrentSecurityContextWithWebPrincipal(Principal principal) {
        if (principal instanceof WebPrincipal) {
            SecurityContext.setCurrent((SecurityContext)this.getSecurityContextForPrincipal(principal));
        }
    }

    public void setCurrentSecurityContext(Principal principal) {
        SecurityContext.setCurrent((SecurityContext)this.getSecurityContextForPrincipal(principal));
    }

    public synchronized void initConfigHelper(ServletContext servletContext) {
        if (this.helper != null) {
            return;
        }
        this.helper = this.getConfigHelper(servletContext);
    }

    public void postConstruct() {
        this.nwListeners = this.networkConfig.getNetworkListeners();
    }

    private static class HttpMessageInfo
    implements MessageInfo {
        private Object request = null;
        private Object response = null;
        private Map map = new HashMap();

        HttpMessageInfo() {
        }

        HttpMessageInfo(HttpServletRequest request, HttpServletResponse response) {
            this.request = request;
            this.response = response;
        }

        public Object getRequestMessage() {
            return this.request;
        }

        public Object getResponseMessage() {
            return this.response;
        }

        public void setRequestMessage(Object request) {
            this.request = request;
        }

        public void setResponseMessage(Object response) {
            this.response = response;
        }

        public Map getMap() {
            return this.map;
        }
    }

    static class AuthenticatorProxy
    extends AuthenticatorBase {
        private AuthenticatorBase authBase;
        private Principal principal;
        private String authType;

        public boolean getCache() {
            return this.authBase.getCache();
        }

        public Container getContainer() {
            return this.authBase.getContainer();
        }

        AuthenticatorProxy(Authenticator authenticator, Principal p, String authType) throws LifecycleException {
            this.authBase = (AuthenticatorBase)authenticator;
            this.principal = p;
            this.authType = authType == null ? PROXY_AUTH_TYPE : authType;
            this.setCache(this.authBase.getCache());
            this.setContainer(this.authBase.getContainer());
            this.start();
        }

        public boolean authenticate(HttpRequest request, HttpResponse response, LoginConfig config) throws IOException {
            if (this.cache) {
                this.getSession(request, true);
            }
            this.register(request, response, this.principal, this.authType, this.principal.getName(), null);
            return true;
        }

        public String getAuthMethod() {
            return this.authType;
        }
    }
}

