/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.impl.authorization;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.security.services.api.authorization.AzResource;
import org.glassfish.security.services.api.common.Attributes;
import org.glassfish.security.services.impl.authorization.AzAttributesImpl;

public final class AzResourceImpl
extends AzAttributesImpl
implements AzResource {
    private static final Logger logger = Logger.getLogger("javax.enterprise.security.services", "org.glassfish.security.services.LogMessages");
    private static final boolean REPLACE = true;
    private final URI uri;
    @LogMessageInfo(message="Unable to decode URI: {0}.", level="WARNING")
    private static final String URI_DECODING_ERROR = "SEC-SVCS-00102";

    public AzResourceImpl(URI resource) {
        super("RESOURCE");
        if (null == resource) {
            throw new IllegalArgumentException("Illegal null resource URI.");
        }
        this.uri = resource;
        AzResourceImpl.addAttributesFromUriQuery(this.uri, this, false);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public String toString() {
        return this.uri.toString();
    }

    static void addAttributesFromUriQuery(URI uri, Attributes attributes, boolean replace) {
        String[] params;
        if (null == uri) {
            throw new IllegalArgumentException("Illegal null URI.");
        }
        if (null == attributes) {
            throw new IllegalArgumentException("Illegal null Attributes.");
        }
        String query = uri.getRawQuery();
        if (null != query && query.length() > 0 && null != (params = query.split("&")) && params.length > 0) {
            for (String nv : params) {
                String value;
                String name;
                if (null == nv || nv.length() <= 0) continue;
                int equalsPos = nv.indexOf("=");
                if (-1 == equalsPos) {
                    name = AzResourceImpl.decodeURI(nv);
                    value = "";
                } else {
                    name = AzResourceImpl.decodeURI(nv.substring(0, equalsPos));
                    value = AzResourceImpl.decodeURI(nv.substring(equalsPos + 1));
                }
                attributes.addAttribute(name, value, replace);
            }
        }
    }

    static String decodeURI(String input) {
        String output;
        block3: {
            if (null == input) {
                return null;
            }
            output = input;
            try {
                output = URLDecoder.decode(input, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, URI_DECODING_ERROR, e.getLocalizedMessage());
            }
        }
        return output;
    }
}

