/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.security.services.provider.authorization;

import com.sun.logging.LogDomains;
import java.net.URI;
import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.security.auth.Subject;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.KernelIdentity;
import org.glassfish.security.services.api.authorization.AuthorizationAdminConstants;
import org.glassfish.security.services.api.authorization.AuthorizationService;
import org.glassfish.security.services.api.authorization.AzAction;
import org.glassfish.security.services.api.authorization.AzAttributeResolver;
import org.glassfish.security.services.api.authorization.AzEnvironment;
import org.glassfish.security.services.api.authorization.AzResource;
import org.glassfish.security.services.api.authorization.AzResult;
import org.glassfish.security.services.api.authorization.AzSubject;
import org.glassfish.security.services.config.SecurityProvider;
import org.glassfish.security.services.impl.NucleusKernelIdentity;
import org.glassfish.security.services.impl.authorization.AzObligationsImpl;
import org.glassfish.security.services.impl.authorization.AzResultImpl;
import org.glassfish.security.services.provider.authorization.AuthorizationProviderConfig;
import org.glassfish.security.services.spi.AuthorizationProvider;
import org.jvnet.hk2.annotations.Service;

@Service(name="simpleAuthorization")
@PerLookup
public class SimpleAuthorizationProviderImpl
implements AuthorizationProvider,
PostConstruct {
    private AuthorizationProviderConfig cfg;
    private boolean deployable;
    private String version;
    @Inject
    private ServerEnvironment serverEnv;
    @Inject
    private ServiceLocator serviceLocator;
    @Inject
    private KernelIdentity kernelIdentity;
    protected static final Logger _logger = LogDomains.getLogger(SimpleAuthorizationProviderImpl.class, (String)"javax.enterprise.system.core.security");
    private final Decider decider = new Decider();

    @Override
    public void initialize(SecurityProvider providerConfig) {
        this.cfg = (AuthorizationProviderConfig)providerConfig.getSecurityProviderConfig().get(0);
        this.deployable = this.cfg.getSupportPolicyDeploy();
        this.version = this.cfg.getVersion();
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "provide to do policy deploy: " + this.deployable);
            _logger.log(Level.FINE, "provide version to use: " + this.version);
        }
    }

    public void postConstruct() {
        this.loadKernelIdentity();
    }

    private void loadKernelIdentity() {
        if (this.kernelIdentity == null) {
            this.kernelIdentity = new NucleusKernelIdentity();
        }
    }

    @Override
    public AzResult getAuthorizationDecision(AzSubject subject, AzResource resource, AzAction action, AzEnvironment environment, List<AzAttributeResolver> attributeResolvers) {
        if (!this.isAdminResource(resource)) {
            String resourceName = resource.getUri() == null ? "null" : resource.getUri().toASCIIString();
            _logger.log(Level.WARNING, resourceName, new IllegalArgumentException(resourceName));
        }
        return this.getAdminDecision(subject, resource, action, environment);
    }

    private boolean isAdminResource(AzResource resource) {
        URI resourceURI = resource.getUri();
        return "admin".equals(resourceURI.getScheme());
    }

    private AzResult getAdminDecision(AzSubject subject, AzResource resource, AzAction action, AzEnvironment environment) {
        AzResultImpl rtn = new AzResultImpl(this.decider.decide(subject, resource, action, environment), AzResult.Status.OK, new AzObligationsImpl());
        return rtn;
    }

    @Override
    public AuthorizationService.PolicyDeploymentContext findOrCreateDeploymentContext(String appContext) {
        return null;
    }

    private class Decider {
        private Decider() {
        }

        private AzResult.Decision decide(AzSubject subject, AzResource resource, AzAction action, AzEnvironment env) {
            AzResult.Decision result = this.isSubjectKernelIdentity(subject.getSubject()) || this.isSubjectTrustedForDASAndInstances(subject) || this.isSubjectAnAdministrator(subject) && (SimpleAuthorizationProviderImpl.this.serverEnv.isDas() || this.isActionRead(action)) ? AzResult.Decision.PERMIT : AzResult.Decision.DENY;
            return result;
        }

        private boolean isSubjectKernelIdentity(Subject s) {
            return !SimpleAuthorizationProviderImpl.this.kernelIdentity.getSubject().getPrincipals(KernelIdentity.KernelPrincipal.class).isEmpty();
        }

        private boolean isSubjectTrustedForDASAndInstances(AzSubject subject) {
            HashSet<String> principalNames = new HashSet<String>();
            for (Principal p : subject.getSubject().getPrincipals()) {
                principalNames.add(p.getName());
            }
            principalNames.retainAll(AuthorizationAdminConstants.TRUSTED_FOR_DAS_OR_INSTANCE);
            return !principalNames.isEmpty();
        }

        private boolean isActionRead(AzAction action) {
            return "read".equals(action.getAction());
        }

        private boolean isSubjectAnAdministrator(AzSubject subject) {
            return this.isPrincipalType(subject, "asadmin");
        }

        private boolean isPrincipalType(AzSubject subject, String type) {
            for (Principal p : subject.getSubject().getPrincipals()) {
                if (!type.equals(p.getName())) continue;
                return true;
            }
            return false;
        }
    }
}

