/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.perms;

import com.sun.enterprise.security.integration.PermissionCreator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class PermissionXMLParser {
    protected static final String PERMISSIONS_XML = "META-INF/permissions.xml";
    protected static final String RESTRICTED_PERMISSIONS_XML = "META-INF/restricted-permissions.xml";
    protected XMLStreamReader parser = null;
    PermissionCollection pc = new Permissions();
    private PermissionCollection permissionCollectionToBeRestricted = null;
    private static XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PermissionXMLParser(File permissionsXmlFile, PermissionCollection permissionCollectionToBeRestricted) throws XMLStreamException, FileNotFoundException {
        FileInputStream fi = null;
        try {
            this.permissionCollectionToBeRestricted = permissionCollectionToBeRestricted;
            fi = new FileInputStream(permissionsXmlFile);
            this.init(fi);
        }
        finally {
            if (fi != null) {
                try {
                    fi.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public PermissionXMLParser(InputStream input, PermissionCollection permissionCollectionToBeRestricted) throws XMLStreamException, FileNotFoundException {
        this.permissionCollectionToBeRestricted = permissionCollectionToBeRestricted;
        this.init(input);
    }

    protected static XMLInputFactory getXMLInputFactory() {
        return xmlInputFactory;
    }

    protected void read(InputStream input) throws XMLStreamException {
        this.parser = PermissionXMLParser.getXMLInputFactory().createXMLStreamReader(input);
        int event = 0;
        String classname = null;
        String target = null;
        String actions = null;
        while (this.parser.hasNext() && (event = this.parser.next()) != 8) {
            String name;
            if (event == 1) {
                name = this.parser.getLocalName();
                if ("permission".equals(name)) {
                    classname = null;
                    target = null;
                    actions = null;
                    continue;
                }
                if ("class-name".equals(name)) {
                    classname = this.parser.getElementText();
                    continue;
                }
                if ("name".equals(name)) {
                    target = this.parser.getElementText();
                    continue;
                }
                if ("actions".equals(name)) {
                    actions = this.parser.getElementText();
                    continue;
                }
                if ("permissions".equals(name)) continue;
                this.skipSubTree(name);
                continue;
            }
            if (event != 2 || !"permission".equals(name = this.parser.getLocalName()) || classname == null || classname.isEmpty()) continue;
            this.addPermission(classname, target, actions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void init(InputStream input) throws XMLStreamException {
        try {
            this.read(input);
        }
        finally {
            if (this.parser != null) {
                try {
                    this.parser.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void skipRoot(String name) throws XMLStreamException {
        int event;
        while ((event = this.parser.next()) != 1) {
        }
        String localName = this.parser.getLocalName();
        if (!name.equals(localName)) {
            throw new XMLStreamException("Unexpected element with name " + name);
        }
    }

    protected void skipSubTree(String name) throws XMLStreamException {
        int event;
        do {
            if ((event = this.parser.next()) != 8) continue;
            throw new XMLStreamException("Unexpected element with name " + name);
        } while (event != 2 || !name.equals(this.parser.getLocalName()));
    }

    private void addPermission(String classname, String target, String actions) {
        try {
            Permission pm = PermissionCreator.getInstance((String)classname, (String)target, (String)actions);
            if (pm != null) {
                if (this.permissionCollectionToBeRestricted != null && this.permissionCollectionToBeRestricted.implies(pm)) {
                    throw new SecurityException("Restricted Permission Declared - fail deployment!");
                }
                this.pc.add(pm);
            }
        }
        catch (ClassNotFoundException e) {
            throw new SecurityException(e);
        }
        catch (NoSuchMethodException e) {
            throw new SecurityException(e);
        }
        catch (InstantiationException e) {
            throw new SecurityException(e);
        }
        catch (IllegalAccessException e) {
            throw new SecurityException(e);
        }
        catch (InvocationTargetException e) {
            throw new SecurityException(e);
        }
    }

    protected PermissionCollection getPermissions() {
        return this.pc;
    }

    static {
        xmlInputFactory.setProperty("javax.xml.stream.supportDTD", false);
        xmlInputFactory.setProperty("javax.xml.stream.isNamespaceAware", true);
        xmlInputFactory.setXMLResolver(new XMLResolver(){

            @Override
            public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
                return new ByteArrayInputStream(new byte[0]);
            }
        });
    }
}

