/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.interfaces.SecurityRoleMapperFactoryMgr;
import com.sun.enterprise.security.PolicyLoader;
import com.sun.enterprise.security.WebSecurityDeployerProbeProvider;
import com.sun.enterprise.security.ee.SecurityDeployer;
import com.sun.enterprise.security.ee.SecurityUtil;
import com.sun.enterprise.security.util.IASSecurityException;
import com.sun.enterprise.security.web.integration.WebSecurityManager;
import com.sun.enterprise.security.web.integration.WebSecurityManagerFactory;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.api.container.Container;
import org.glassfish.api.deployment.Deployer;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="com.sun.enterprise.security.ee.SecurityContainer")
public class SecurityContainer
implements Container,
PostConstruct {
    @Inject
    private PolicyLoader policyLoader;
    @Inject
    private ServerContext serverContext;
    @Inject
    private Habitat habitat;
    @Inject
    private Provider<ClassLoaderHierarchy> classLoaderHierarchyProvider;
    @Inject
    private Provider<WebSecurityManagerFactory> webSecurityManagerFactoryProvider;
    public static final String DEFAULT_WEB_MODULE_NAME = "__default-web-module";
    private static WebSecurityDeployerProbeProvider websecurityProbeProvider;

    public String getName() {
        return "Security";
    }

    public Class<? extends Deployer> getDeployer() {
        return SecurityDeployer.class;
    }

    public void postConstruct() {
        WebBundleDescriptor wbd = new WebBundleDescriptor();
        Application application = Application.createApplication();
        application.setVirtual(true);
        application.setName(DEFAULT_WEB_MODULE_NAME);
        application.setRegistrationName(DEFAULT_WEB_MODULE_NAME);
        wbd.setApplication(application);
        this.generatePolicy(wbd);
    }

    private void generatePolicy(WebBundleDescriptor wbd) {
        String name = null;
        ClassLoader oldTcc = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoaderHierarchy hierarchy = (ClassLoaderHierarchy)this.classLoaderHierarchyProvider.get();
            ClassLoader tcc = hierarchy.getCommonClassLoader();
            Thread.currentThread().setContextClassLoader(tcc);
            this.policyLoader.loadPolicy();
            WebSecurityManagerFactory wsmf = (WebSecurityManagerFactory)((Object)this.webSecurityManagerFactoryProvider.get());
            wsmf.createManager(wbd, true, this.serverContext);
            name = WebSecurityManager.getContextID(wbd);
            SecurityUtil.generatePolicyFile(name);
            websecurityProbeProvider.policyCreationEvent(name);
        }
        catch (IASSecurityException se) {
            String msg = "Error in generating security policy for " + name;
            throw new RuntimeException(msg, se);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldTcc);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initRoleMapperFactory() {
        Object o = null;
        Class<?> c = null;
        try {
            c = Class.forName("com.sun.enterprise.security.acl.RoleMapperFactory");
            if (c != null && (o = c.newInstance()) != null && o instanceof SecurityRoleMapperFactory) {
                SecurityRoleMapperFactoryMgr.registerFactory((SecurityRoleMapperFactory)o);
            }
            if (o != null) return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        SecurityContainer.initRoleMapperFactory();
        websecurityProbeProvider = new WebSecurityDeployerProbeProvider();
    }
}

