/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.sun.enterprise.security.acl.RoleMapper;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.glassfish.deployment.common.SecurityRoleMapper;
import org.glassfish.deployment.common.SecurityRoleMapperFactory;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class RoleMapperFactory
implements SecurityRoleMapperFactory {
    private Map CONTEXT_TO_APPNAME = new HashMap();
    private Hashtable ROLEMAPPER = new Hashtable();

    public SecurityRoleMapper getRoleMapper(String appName) {
        String contextId = appName;
        String appname = this.getAppNameForContext(appName);
        RoleMapper srm = null;
        if (appname != null) {
            srm = this.getRoleMapper(appname, this);
        }
        if (srm == null) {
            srm = this.getRoleMapper(contextId, this);
        }
        return srm;
    }

    public String getAppNameForContext(String contextId) {
        return (String)this.CONTEXT_TO_APPNAME.get(contextId);
    }

    public void setAppNameForContext(String appName, String contextId) {
        this.CONTEXT_TO_APPNAME.put(contextId, appName);
    }

    public void removeAppNameForContext(String contextId) {
        this.CONTEXT_TO_APPNAME.remove(contextId);
    }

    public RoleMapper getRoleMapper(String appName, SecurityRoleMapperFactory fact) {
        RoleMapper r = (RoleMapper)this.ROLEMAPPER.get(appName);
        if (r == null) {
            r = new RoleMapper(appName);
            this.ROLEMAPPER.put(appName, r);
        }
        return r;
    }

    public void setRoleMapper(String appName, SecurityRoleMapper rmap) {
        this.ROLEMAPPER.put(appName, rmap);
    }

    public void removeRoleMapper(String appName) {
        if (this.ROLEMAPPER.containsKey(appName)) {
            this.ROLEMAPPER.remove(appName);
        }
    }
}

